/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Refreshes one or multiple data source objects in the spreadsheet by the specified references. The
 * request requires an additional bigquery.readonly OAuth scope. If there're multiple refresh
 * requests referencing the same data source objects in one batch, only the last refresh request is
 * processed, and all those requests will have the same response accordingly.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RefreshDataSourceRequest extends com.google.api.client.json.GenericJson {

  /**
   * Reference to a DataSource. If specified, refreshes all associated data source objects for the
   * data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * Refreshes the data source objects regardless of the current state. If not set and a referenced
   * data source object was in error state, the refresh will fail immediately.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * Refreshes all existing data source objects in the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAll;

  /**
   * References to data source objects to refresh.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceObjectReferences references;

  /**
   * Reference to a DataSource. If specified, refreshes all associated data source objects for the
   * data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * Reference to a DataSource. If specified, refreshes all associated data source objects for the
   * data source.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public RefreshDataSourceRequest setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * Refreshes the data source objects regardless of the current state. If not set and a referenced
   * data source object was in error state, the refresh will fail immediately.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * Refreshes the data source objects regardless of the current state. If not set and a referenced
   * data source object was in error state, the refresh will fail immediately.
   * @param force force or {@code null} for none
   */
  public RefreshDataSourceRequest setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * Refreshes all existing data source objects in the spreadsheet.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAll() {
    return isAll;
  }

  /**
   * Refreshes all existing data source objects in the spreadsheet.
   * @param isAll isAll or {@code null} for none
   */
  public RefreshDataSourceRequest setIsAll(java.lang.Boolean isAll) {
    this.isAll = isAll;
    return this;
  }

  /**
   * References to data source objects to refresh.
   * @return value or {@code null} for none
   */
  public DataSourceObjectReferences getReferences() {
    return references;
  }

  /**
   * References to data source objects to refresh.
   * @param references references or {@code null} for none
   */
  public RefreshDataSourceRequest setReferences(DataSourceObjectReferences references) {
    this.references = references;
    return this;
  }

  @Override
  public RefreshDataSourceRequest set(String fieldName, Object value) {
    return (RefreshDataSourceRequest) super.set(fieldName, value);
  }

  @Override
  public RefreshDataSourceRequest clone() {
    return (RefreshDataSourceRequest) super.clone();
  }

}
