/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The specification of a BigQuery data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigQueryDataSourceSpec extends com.google.api.client.json.GenericJson {

  /**
   * The ID of a BigQuery enabled GCP project with a billing account attached. For any queries
   * executed against the data source, the project is charged.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * A BigQueryQuerySpec.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigQueryQuerySpec querySpec;

  /**
   * A BigQueryTableSpec.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigQueryTableSpec tableSpec;

  /**
   * The ID of a BigQuery enabled GCP project with a billing account attached. For any queries
   * executed against the data source, the project is charged.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of a BigQuery enabled GCP project with a billing account attached. For any queries
   * executed against the data source, the project is charged.
   * @param projectId projectId or {@code null} for none
   */
  public BigQueryDataSourceSpec setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * A BigQueryQuerySpec.
   * @return value or {@code null} for none
   */
  public BigQueryQuerySpec getQuerySpec() {
    return querySpec;
  }

  /**
   * A BigQueryQuerySpec.
   * @param querySpec querySpec or {@code null} for none
   */
  public BigQueryDataSourceSpec setQuerySpec(BigQueryQuerySpec querySpec) {
    this.querySpec = querySpec;
    return this;
  }

  /**
   * A BigQueryTableSpec.
   * @return value or {@code null} for none
   */
  public BigQueryTableSpec getTableSpec() {
    return tableSpec;
  }

  /**
   * A BigQueryTableSpec.
   * @param tableSpec tableSpec or {@code null} for none
   */
  public BigQueryDataSourceSpec setTableSpec(BigQueryTableSpec tableSpec) {
    this.tableSpec = tableSpec;
    return this;
  }

  @Override
  public BigQueryDataSourceSpec set(String fieldName, Object value) {
    return (BigQueryDataSourceSpec) super.set(fieldName, value);
  }

  @Override
  public BigQueryDataSourceSpec clone() {
    return (BigQueryDataSourceSpec) super.clone();
  }

}
