/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The data source refresh schedule. All data sources in the spreadsheet are scheduled to refresh in
 * a future time interval. The time interval size defaults to the one defined in the Sheets editor.
 * For example, if a daily schedule at start time of 8am is scheduled, and the time interval is 4
 * hours, the scheduled refresh will happen between 8am and 12pm every day.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSourceRefreshSchedule extends com.google.api.client.json.GenericJson {

  /**
   * Daily refresh schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceRefreshDailySchedule dailySchedule;

  /**
   * True if the refresh schedule is enabled, or false otherwise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * Monthly refresh schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceRefreshMonthlySchedule monthlySchedule;

  /**
   * Output only. The time interval of the next run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Interval nextRun;

  /**
   * The scope of the refresh.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String refreshScope;

  /**
   * Weekly refresh schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceRefreshWeeklySchedule weeklySchedule;

  /**
   * Daily refresh schedule.
   * @return value or {@code null} for none
   */
  public DataSourceRefreshDailySchedule getDailySchedule() {
    return dailySchedule;
  }

  /**
   * Daily refresh schedule.
   * @param dailySchedule dailySchedule or {@code null} for none
   */
  public DataSourceRefreshSchedule setDailySchedule(DataSourceRefreshDailySchedule dailySchedule) {
    this.dailySchedule = dailySchedule;
    return this;
  }

  /**
   * True if the refresh schedule is enabled, or false otherwise.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * True if the refresh schedule is enabled, or false otherwise.
   * @param enabled enabled or {@code null} for none
   */
  public DataSourceRefreshSchedule setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Monthly refresh schedule.
   * @return value or {@code null} for none
   */
  public DataSourceRefreshMonthlySchedule getMonthlySchedule() {
    return monthlySchedule;
  }

  /**
   * Monthly refresh schedule.
   * @param monthlySchedule monthlySchedule or {@code null} for none
   */
  public DataSourceRefreshSchedule setMonthlySchedule(DataSourceRefreshMonthlySchedule monthlySchedule) {
    this.monthlySchedule = monthlySchedule;
    return this;
  }

  /**
   * Output only. The time interval of the next run.
   * @return value or {@code null} for none
   */
  public Interval getNextRun() {
    return nextRun;
  }

  /**
   * Output only. The time interval of the next run.
   * @param nextRun nextRun or {@code null} for none
   */
  public DataSourceRefreshSchedule setNextRun(Interval nextRun) {
    this.nextRun = nextRun;
    return this;
  }

  /**
   * The scope of the refresh.
   * @return value or {@code null} for none
   */
  public java.lang.String getRefreshScope() {
    return refreshScope;
  }

  /**
   * The scope of the refresh.
   * @param refreshScope refreshScope or {@code null} for none
   */
  public DataSourceRefreshSchedule setRefreshScope(java.lang.String refreshScope) {
    this.refreshScope = refreshScope;
    return this;
  }

  /**
   * Weekly refresh schedule.
   * @return value or {@code null} for none
   */
  public DataSourceRefreshWeeklySchedule getWeeklySchedule() {
    return weeklySchedule;
  }

  /**
   * Weekly refresh schedule.
   * @param weeklySchedule weeklySchedule or {@code null} for none
   */
  public DataSourceRefreshSchedule setWeeklySchedule(DataSourceRefreshWeeklySchedule weeklySchedule) {
    this.weeklySchedule = weeklySchedule;
    return this;
  }

  @Override
  public DataSourceRefreshSchedule set(String fieldName, Object value) {
    return (DataSourceRefreshSchedule) super.set(fieldName, value);
  }

  @Override
  public DataSourceRefreshSchedule clone() {
    return (DataSourceRefreshSchedule) super.clone();
  }

}
