/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A data source table, allowing to import a static table of data from the DataSource into Sheets.
 * This is also known as "Extract" in the Sheets editor.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSourceTable extends com.google.api.client.json.GenericJson {

  /**
   * The type to select columns for the data source table. Defaults to SELECTED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String columnSelectionType;

  /**
   * Columns selected for the data source table. The column_selection_type must be SELECTED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataSourceColumnReference> columns;

  static {
    // hack to force ProGuard to consider DataSourceColumnReference used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataSourceColumnReference.class);
  }

  /**
   * Output only. The data execution status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataExecutionStatus dataExecutionStatus;

  /**
   * The ID of the data source the data source table is associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * Filter specifications in the data source table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FilterSpec> filterSpecs;

  /**
   * The limit of rows to return. If not set, a default limit is applied. Please refer to the Sheets
   * editor for the default and max limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rowLimit;

  /**
   * Sort specifications in the data source table. The result of the data source table is sorted
   * based on the sort specifications in order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SortSpec> sortSpecs;

  /**
   * The type to select columns for the data source table. Defaults to SELECTED.
   * @return value or {@code null} for none
   */
  public java.lang.String getColumnSelectionType() {
    return columnSelectionType;
  }

  /**
   * The type to select columns for the data source table. Defaults to SELECTED.
   * @param columnSelectionType columnSelectionType or {@code null} for none
   */
  public DataSourceTable setColumnSelectionType(java.lang.String columnSelectionType) {
    this.columnSelectionType = columnSelectionType;
    return this;
  }

  /**
   * Columns selected for the data source table. The column_selection_type must be SELECTED.
   * @return value or {@code null} for none
   */
  public java.util.List<DataSourceColumnReference> getColumns() {
    return columns;
  }

  /**
   * Columns selected for the data source table. The column_selection_type must be SELECTED.
   * @param columns columns or {@code null} for none
   */
  public DataSourceTable setColumns(java.util.List<DataSourceColumnReference> columns) {
    this.columns = columns;
    return this;
  }

  /**
   * Output only. The data execution status.
   * @return value or {@code null} for none
   */
  public DataExecutionStatus getDataExecutionStatus() {
    return dataExecutionStatus;
  }

  /**
   * Output only. The data execution status.
   * @param dataExecutionStatus dataExecutionStatus or {@code null} for none
   */
  public DataSourceTable setDataExecutionStatus(DataExecutionStatus dataExecutionStatus) {
    this.dataExecutionStatus = dataExecutionStatus;
    return this;
  }

  /**
   * The ID of the data source the data source table is associated with.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * The ID of the data source the data source table is associated with.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public DataSourceTable setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * Filter specifications in the data source table.
   * @return value or {@code null} for none
   */
  public java.util.List<FilterSpec> getFilterSpecs() {
    return filterSpecs;
  }

  /**
   * Filter specifications in the data source table.
   * @param filterSpecs filterSpecs or {@code null} for none
   */
  public DataSourceTable setFilterSpecs(java.util.List<FilterSpec> filterSpecs) {
    this.filterSpecs = filterSpecs;
    return this;
  }

  /**
   * The limit of rows to return. If not set, a default limit is applied. Please refer to the Sheets
   * editor for the default and max limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRowLimit() {
    return rowLimit;
  }

  /**
   * The limit of rows to return. If not set, a default limit is applied. Please refer to the Sheets
   * editor for the default and max limit.
   * @param rowLimit rowLimit or {@code null} for none
   */
  public DataSourceTable setRowLimit(java.lang.Integer rowLimit) {
    this.rowLimit = rowLimit;
    return this;
  }

  /**
   * Sort specifications in the data source table. The result of the data source table is sorted
   * based on the sort specifications in order.
   * @return value or {@code null} for none
   */
  public java.util.List<SortSpec> getSortSpecs() {
    return sortSpecs;
  }

  /**
   * Sort specifications in the data source table. The result of the data source table is sorted
   * based on the sort specifications in order.
   * @param sortSpecs sortSpecs or {@code null} for none
   */
  public DataSourceTable setSortSpecs(java.util.List<SortSpec> sortSpecs) {
    this.sortSpecs = sortSpecs;
    return this;
  }

  @Override
  public DataSourceTable set(String fieldName, Object value) {
    return (DataSourceTable) super.set(fieldName, value);
  }

  @Override
  public DataSourceTable clone() {
    return (DataSourceTable) super.clone();
  }

}
