/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates a data source. After the data source is updated successfully, an execution is triggered
 * to refresh the associated DataSource sheet to read data from the updated data source. The request
 * requires an additional bigquery.readonly OAuth scope.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateDataSourceRequest extends com.google.api.client.json.GenericJson {

  /**
   * The data source to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSource dataSource;

  /**
   * The fields that should be updated. At least one field must be specified. The root 'dataSource'
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The data source to update.
   * @return value or {@code null} for none
   */
  public DataSource getDataSource() {
    return dataSource;
  }

  /**
   * The data source to update.
   * @param dataSource dataSource or {@code null} for none
   */
  public UpdateDataSourceRequest setDataSource(DataSource dataSource) {
    this.dataSource = dataSource;
    return this;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root 'dataSource'
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root 'dataSource'
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @param fields fields or {@code null} for none
   */
  public UpdateDataSourceRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  @Override
  public UpdateDataSourceRequest set(String fieldName, Object value) {
    return (UpdateDataSourceRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateDataSourceRequest clone() {
    return (UpdateDataSourceRequest) super.clone();
  }

}
