/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The data included in a domain or series.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChartData extends com.google.api.client.json.GenericJson {

  /**
   * The aggregation type for the series of a data source chart. Not supported for regular charts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregateType;

  /**
   * The reference to the data source column that the data reads from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceColumnReference columnReference;

  /**
   * The rule to group the data by if the ChartData backs the domain of a data source chart. Not
   * supported for regular charts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartGroupRule groupRule;

  /**
   * The source ranges of the data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartSourceRange sourceRange;

  /**
   * The aggregation type for the series of a data source chart. Not supported for regular charts.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregateType() {
    return aggregateType;
  }

  /**
   * The aggregation type for the series of a data source chart. Not supported for regular charts.
   * @param aggregateType aggregateType or {@code null} for none
   */
  public ChartData setAggregateType(java.lang.String aggregateType) {
    this.aggregateType = aggregateType;
    return this;
  }

  /**
   * The reference to the data source column that the data reads from.
   * @return value or {@code null} for none
   */
  public DataSourceColumnReference getColumnReference() {
    return columnReference;
  }

  /**
   * The reference to the data source column that the data reads from.
   * @param columnReference columnReference or {@code null} for none
   */
  public ChartData setColumnReference(DataSourceColumnReference columnReference) {
    this.columnReference = columnReference;
    return this;
  }

  /**
   * The rule to group the data by if the ChartData backs the domain of a data source chart. Not
   * supported for regular charts.
   * @return value or {@code null} for none
   */
  public ChartGroupRule getGroupRule() {
    return groupRule;
  }

  /**
   * The rule to group the data by if the ChartData backs the domain of a data source chart. Not
   * supported for regular charts.
   * @param groupRule groupRule or {@code null} for none
   */
  public ChartData setGroupRule(ChartGroupRule groupRule) {
    this.groupRule = groupRule;
    return this;
  }

  /**
   * The source ranges of the data.
   * @return value or {@code null} for none
   */
  public ChartSourceRange getSourceRange() {
    return sourceRange;
  }

  /**
   * The source ranges of the data.
   * @param sourceRange sourceRange or {@code null} for none
   */
  public ChartData setSourceRange(ChartSourceRange sourceRange) {
    this.sourceRange = sourceRange;
    return this;
  }

  @Override
  public ChartData set(String fieldName, Object value) {
    return (ChartData) super.set(fieldName, value);
  }

  @Override
  public ChartData clone() {
    return (ChartData) super.clone();
  }

}
