/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The status of a refresh cancellation. You can send a cancel request to explicitly cancel one or
 * multiple data source object refreshes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RefreshCancellationStatus extends com.google.api.client.json.GenericJson {

  /**
   * The error code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorCode;

  /**
   * The state of a call to cancel a refresh in Sheets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The error code.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorCode() {
    return errorCode;
  }

  /**
   * The error code.
   * @param errorCode errorCode or {@code null} for none
   */
  public RefreshCancellationStatus setErrorCode(java.lang.String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The state of a call to cancel a refresh in Sheets.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The state of a call to cancel a refresh in Sheets.
   * @param state state or {@code null} for none
   */
  public RefreshCancellationStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public RefreshCancellationStatus set(String fieldName, Object value) {
    return (RefreshCancellationStatus) super.set(fieldName, value);
  }

  @Override
  public RefreshCancellationStatus clone() {
    return (RefreshCancellationStatus) super.clone();
  }

}
