/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A data validation rule for a column in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableColumnDataValidationRule extends com.google.api.client.json.GenericJson {

  /**
   * The condition that data in the cell must match. Valid only if the [BooleanCondition.type] is
   * ONE_OF_LIST.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BooleanCondition condition;

  /**
   * The condition that data in the cell must match. Valid only if the [BooleanCondition.type] is
   * ONE_OF_LIST.
   * @return value or {@code null} for none
   */
  public BooleanCondition getCondition() {
    return condition;
  }

  /**
   * The condition that data in the cell must match. Valid only if the [BooleanCondition.type] is
   * ONE_OF_LIST.
   * @param condition condition or {@code null} for none
   */
  public TableColumnDataValidationRule setCondition(BooleanCondition condition) {
    this.condition = condition;
    return this;
  }

  @Override
  public TableColumnDataValidationRule set(String fieldName, Object value) {
    return (TableColumnDataValidationRule) super.set(fieldName, value);
  }

  @Override
  public TableColumnDataValidationRule clone() {
    return (TableColumnDataValidationRule) super.clone();
  }

}
