/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The table column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableColumnProperties extends com.google.api.client.json.GenericJson {

  /**
   * The 0-based column index. This index is relative to its position in the table and is not
   * necessarily the same as the column index in the sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer columnIndex;

  /**
   * The column name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String columnName;

  /**
   * The column type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String columnType;

  /**
   * The column data validation rule. Only set for dropdown column type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableColumnDataValidationRule dataValidationRule;

  /**
   * The 0-based column index. This index is relative to its position in the table and is not
   * necessarily the same as the column index in the sheet.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getColumnIndex() {
    return columnIndex;
  }

  /**
   * The 0-based column index. This index is relative to its position in the table and is not
   * necessarily the same as the column index in the sheet.
   * @param columnIndex columnIndex or {@code null} for none
   */
  public TableColumnProperties setColumnIndex(java.lang.Integer columnIndex) {
    this.columnIndex = columnIndex;
    return this;
  }

  /**
   * The column name.
   * @return value or {@code null} for none
   */
  public java.lang.String getColumnName() {
    return columnName;
  }

  /**
   * The column name.
   * @param columnName columnName or {@code null} for none
   */
  public TableColumnProperties setColumnName(java.lang.String columnName) {
    this.columnName = columnName;
    return this;
  }

  /**
   * The column type.
   * @return value or {@code null} for none
   */
  public java.lang.String getColumnType() {
    return columnType;
  }

  /**
   * The column type.
   * @param columnType columnType or {@code null} for none
   */
  public TableColumnProperties setColumnType(java.lang.String columnType) {
    this.columnType = columnType;
    return this;
  }

  /**
   * The column data validation rule. Only set for dropdown column type.
   * @return value or {@code null} for none
   */
  public TableColumnDataValidationRule getDataValidationRule() {
    return dataValidationRule;
  }

  /**
   * The column data validation rule. Only set for dropdown column type.
   * @param dataValidationRule dataValidationRule or {@code null} for none
   */
  public TableColumnProperties setDataValidationRule(TableColumnDataValidationRule dataValidationRule) {
    this.dataValidationRule = dataValidationRule;
    return this;
  }

  @Override
  public TableColumnProperties set(String fieldName, Object value) {
    return (TableColumnProperties) super.set(fieldName, value);
  }

  @Override
  public TableColumnProperties clone() {
    return (TableColumnProperties) super.clone();
  }

}
