/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-12 at 18:16:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A chart embedded in a sheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmbeddedChart extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer chartId;

  /**
   * The position of the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedObjectPosition position;

  /**
   * The specification of the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartSpec spec;

  /**
   * The ID of the chart.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getChartId() {
    return chartId;
  }

  /**
   * The ID of the chart.
   * @param chartId chartId or {@code null} for none
   */
  public EmbeddedChart setChartId(java.lang.Integer chartId) {
    this.chartId = chartId;
    return this;
  }

  /**
   * The position of the chart.
   * @return value or {@code null} for none
   */
  public EmbeddedObjectPosition getPosition() {
    return position;
  }

  /**
   * The position of the chart.
   * @param position position or {@code null} for none
   */
  public EmbeddedChart setPosition(EmbeddedObjectPosition position) {
    this.position = position;
    return this;
  }

  /**
   * The specification of the chart.
   * @return value or {@code null} for none
   */
  public ChartSpec getSpec() {
    return spec;
  }

  /**
   * The specification of the chart.
   * @param spec spec or {@code null} for none
   */
  public EmbeddedChart setSpec(ChartSpec spec) {
    this.spec = spec;
    return this;
  }

  @Override
  public EmbeddedChart set(String fieldName, Object value) {
    return (EmbeddedChart) super.set(fieldName, value);
  }

  @Override
  public EmbeddedChart clone() {
    return (EmbeddedChart) super.clone();
  }

}
