/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-19 at 21:07:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A range along a single dimension on a sheet. All indexes are zero-based. Indexes are half open:
 * the start index is inclusive and the end index is exclusive. Missing indexes indicate the range
 * is unbounded on that side.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionRange extends com.google.api.client.json.GenericJson {

  /**
   * The dimension of the span.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimension;

  /**
   * The end (exclusive) of the span, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endIndex;

  /**
   * The sheet this span is on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * The start (inclusive) of the span, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The dimension of the span.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimension() {
    return dimension;
  }

  /**
   * The dimension of the span.
   * @param dimension dimension or {@code null} for none
   */
  public DimensionRange setDimension(java.lang.String dimension) {
    this.dimension = dimension;
    return this;
  }

  /**
   * The end (exclusive) of the span, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndIndex() {
    return endIndex;
  }

  /**
   * The end (exclusive) of the span, or not set if unbounded.
   * @param endIndex endIndex or {@code null} for none
   */
  public DimensionRange setEndIndex(java.lang.Integer endIndex) {
    this.endIndex = endIndex;
    return this;
  }

  /**
   * The sheet this span is on.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet this span is on.
   * @param sheetId sheetId or {@code null} for none
   */
  public DimensionRange setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  /**
   * The start (inclusive) of the span, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The start (inclusive) of the span, or not set if unbounded.
   * @param startIndex startIndex or {@code null} for none
   */
  public DimensionRange setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  @Override
  public DimensionRange set(String fieldName, Object value) {
    return (DimensionRange) super.set(fieldName, value);
  }

  @Override
  public DimensionRange clone() {
    return (DimensionRange) super.clone();
  }

}
