/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-19 at 21:07:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A sort order associated with a specific column or row.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SortSpec extends com.google.api.client.json.GenericJson {

  /**
   * The dimension the sort should be applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer dimensionIndex;

  /**
   * The order data should be sorted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sortOrder;

  /**
   * The dimension the sort should be applied to.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDimensionIndex() {
    return dimensionIndex;
  }

  /**
   * The dimension the sort should be applied to.
   * @param dimensionIndex dimensionIndex or {@code null} for none
   */
  public SortSpec setDimensionIndex(java.lang.Integer dimensionIndex) {
    this.dimensionIndex = dimensionIndex;
    return this;
  }

  /**
   * The order data should be sorted.
   * @return value or {@code null} for none
   */
  public java.lang.String getSortOrder() {
    return sortOrder;
  }

  /**
   * The order data should be sorted.
   * @param sortOrder sortOrder or {@code null} for none
   */
  public SortSpec setSortOrder(java.lang.String sortOrder) {
    this.sortOrder = sortOrder;
    return this;
  }

  @Override
  public SortSpec set(String fieldName, Object value) {
    return (SortSpec) super.set(fieldName, value);
  }

  @Override
  public SortSpec clone() {
    return (SortSpec) super.clone();
  }

}
