/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-26 at 19:49:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A data validation rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataValidationRule extends com.google.api.client.json.GenericJson {

  /**
   * The condition that data in the cell must match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BooleanCondition condition;

  /**
   * A message to show the user when adding data to the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inputMessage;

  /**
   * True if the UI should be customized based on the kind of condition. If true, "List" conditions
   * will show a dropdown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showCustomUi;

  /**
   * True if invalid data should be rejected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean strict;

  /**
   * The condition that data in the cell must match.
   * @return value or {@code null} for none
   */
  public BooleanCondition getCondition() {
    return condition;
  }

  /**
   * The condition that data in the cell must match.
   * @param condition condition or {@code null} for none
   */
  public DataValidationRule setCondition(BooleanCondition condition) {
    this.condition = condition;
    return this;
  }

  /**
   * A message to show the user when adding data to the cell.
   * @return value or {@code null} for none
   */
  public java.lang.String getInputMessage() {
    return inputMessage;
  }

  /**
   * A message to show the user when adding data to the cell.
   * @param inputMessage inputMessage or {@code null} for none
   */
  public DataValidationRule setInputMessage(java.lang.String inputMessage) {
    this.inputMessage = inputMessage;
    return this;
  }

  /**
   * True if the UI should be customized based on the kind of condition. If true, "List" conditions
   * will show a dropdown.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowCustomUi() {
    return showCustomUi;
  }

  /**
   * True if the UI should be customized based on the kind of condition. If true, "List" conditions
   * will show a dropdown.
   * @param showCustomUi showCustomUi or {@code null} for none
   */
  public DataValidationRule setShowCustomUi(java.lang.Boolean showCustomUi) {
    this.showCustomUi = showCustomUi;
    return this;
  }

  /**
   * True if invalid data should be rejected.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getStrict() {
    return strict;
  }

  /**
   * True if invalid data should be rejected.
   * @param strict strict or {@code null} for none
   */
  public DataValidationRule setStrict(java.lang.Boolean strict) {
    this.strict = strict;
    return this;
  }

  @Override
  public DataValidationRule set(String fieldName, Object value) {
    return (DataValidationRule) super.set(fieldName, value);
  }

  @Override
  public DataValidationRule clone() {
    return (DataValidationRule) super.clone();
  }

}
