/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-03 at 18:15:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The specification for a basic chart.  See BasicChartType for the list of charts this supports.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BasicChartSpec extends com.google.api.client.json.GenericJson {

  /**
   * The axis on the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BasicChartAxis> axis;

  static {
    // hack to force ProGuard to consider BasicChartAxis used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(BasicChartAxis.class);
  }

  /**
   * The type of the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chartType;

  /**
   * The domain of data this is charting. Only a single domain is currently supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BasicChartDomain> domains;

  static {
    // hack to force ProGuard to consider BasicChartDomain used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(BasicChartDomain.class);
  }

  /**
   * The number of rows or columns in the data that are "headers". If not set, Google Sheets will
   * guess how many rows are headers based on the data.
   *
   * (Note that BasicChartAxis.title may override the axis title  inferred from the header values.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer headerCount;

  /**
   * The position of the chart legend.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String legendPosition;

  /**
   * The data this chart is visualizing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BasicChartSeries> series;

  static {
    // hack to force ProGuard to consider BasicChartSeries used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(BasicChartSeries.class);
  }

  /**
   * The axis on the chart.
   * @return value or {@code null} for none
   */
  public java.util.List<BasicChartAxis> getAxis() {
    return axis;
  }

  /**
   * The axis on the chart.
   * @param axis axis or {@code null} for none
   */
  public BasicChartSpec setAxis(java.util.List<BasicChartAxis> axis) {
    this.axis = axis;
    return this;
  }

  /**
   * The type of the chart.
   * @return value or {@code null} for none
   */
  public java.lang.String getChartType() {
    return chartType;
  }

  /**
   * The type of the chart.
   * @param chartType chartType or {@code null} for none
   */
  public BasicChartSpec setChartType(java.lang.String chartType) {
    this.chartType = chartType;
    return this;
  }

  /**
   * The domain of data this is charting. Only a single domain is currently supported.
   * @return value or {@code null} for none
   */
  public java.util.List<BasicChartDomain> getDomains() {
    return domains;
  }

  /**
   * The domain of data this is charting. Only a single domain is currently supported.
   * @param domains domains or {@code null} for none
   */
  public BasicChartSpec setDomains(java.util.List<BasicChartDomain> domains) {
    this.domains = domains;
    return this;
  }

  /**
   * The number of rows or columns in the data that are "headers". If not set, Google Sheets will
   * guess how many rows are headers based on the data.
   *
   * (Note that BasicChartAxis.title may override the axis title  inferred from the header values.)
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHeaderCount() {
    return headerCount;
  }

  /**
   * The number of rows or columns in the data that are "headers". If not set, Google Sheets will
   * guess how many rows are headers based on the data.
   *
   * (Note that BasicChartAxis.title may override the axis title  inferred from the header values.)
   * @param headerCount headerCount or {@code null} for none
   */
  public BasicChartSpec setHeaderCount(java.lang.Integer headerCount) {
    this.headerCount = headerCount;
    return this;
  }

  /**
   * The position of the chart legend.
   * @return value or {@code null} for none
   */
  public java.lang.String getLegendPosition() {
    return legendPosition;
  }

  /**
   * The position of the chart legend.
   * @param legendPosition legendPosition or {@code null} for none
   */
  public BasicChartSpec setLegendPosition(java.lang.String legendPosition) {
    this.legendPosition = legendPosition;
    return this;
  }

  /**
   * The data this chart is visualizing.
   * @return value or {@code null} for none
   */
  public java.util.List<BasicChartSeries> getSeries() {
    return series;
  }

  /**
   * The data this chart is visualizing.
   * @param series series or {@code null} for none
   */
  public BasicChartSpec setSeries(java.util.List<BasicChartSeries> series) {
    this.series = series;
    return this;
  }

  @Override
  public BasicChartSpec set(String fieldName, Object value) {
    return (BasicChartSpec) super.set(fieldName, value);
  }

  @Override
  public BasicChartSpec clone() {
    return (BasicChartSpec) super.clone();
  }

}
