/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-19 20:48:09 UTC)
 * on 2016-05-30 at 18:41:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The reply for batch updating a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateSpreadsheetResponse extends com.google.api.client.json.GenericJson {

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Response> replies;

  static {
    // hack to force ProGuard to consider Response used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Response.class);
  }

  /**
   * The spreadsheet the updates were applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spreadsheetId;

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<Response> getReplies() {
    return replies;
  }

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * @param replies replies or {@code null} for none
   */
  public BatchUpdateSpreadsheetResponse setReplies(java.util.List<Response> replies) {
    this.replies = replies;
    return this;
  }

  /**
   * The spreadsheet the updates were applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpreadsheetId() {
    return spreadsheetId;
  }

  /**
   * The spreadsheet the updates were applied to.
   * @param spreadsheetId spreadsheetId or {@code null} for none
   */
  public BatchUpdateSpreadsheetResponse setSpreadsheetId(java.lang.String spreadsheetId) {
    this.spreadsheetId = spreadsheetId;
    return this;
  }

  @Override
  public BatchUpdateSpreadsheetResponse set(String fieldName, Object value) {
    return (BatchUpdateSpreadsheetResponse) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateSpreadsheetResponse clone() {
    return (BatchUpdateSpreadsheetResponse) super.clone();
  }

}
