/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-22 at 00:35:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The reply for batch updating a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateSpreadsheetResponse extends com.google.api.client.json.GenericJson {

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Response> replies;

  static {
    // hack to force ProGuard to consider Response used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Response.class);
  }

  /**
   * The spreadsheet the updates were applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spreadsheetId;

  /**
   * The spreadsheet after updates were applied. This is only set if
   * [BatchUpdateSpreadsheetRequest.include_spreadsheet_in_response] is `true`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Spreadsheet updatedSpreadsheet;

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<Response> getReplies() {
    return replies;
  }

  /**
   * The reply of the updates.  This maps 1:1 with the updates, although replies to some requests
   * may be empty.
   * @param replies replies or {@code null} for none
   */
  public BatchUpdateSpreadsheetResponse setReplies(java.util.List<Response> replies) {
    this.replies = replies;
    return this;
  }

  /**
   * The spreadsheet the updates were applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpreadsheetId() {
    return spreadsheetId;
  }

  /**
   * The spreadsheet the updates were applied to.
   * @param spreadsheetId spreadsheetId or {@code null} for none
   */
  public BatchUpdateSpreadsheetResponse setSpreadsheetId(java.lang.String spreadsheetId) {
    this.spreadsheetId = spreadsheetId;
    return this;
  }

  /**
   * The spreadsheet after updates were applied. This is only set if
   * [BatchUpdateSpreadsheetRequest.include_spreadsheet_in_response] is `true`.
   * @return value or {@code null} for none
   */
  public Spreadsheet getUpdatedSpreadsheet() {
    return updatedSpreadsheet;
  }

  /**
   * The spreadsheet after updates were applied. This is only set if
   * [BatchUpdateSpreadsheetRequest.include_spreadsheet_in_response] is `true`.
   * @param updatedSpreadsheet updatedSpreadsheet or {@code null} for none
   */
  public BatchUpdateSpreadsheetResponse setUpdatedSpreadsheet(Spreadsheet updatedSpreadsheet) {
    this.updatedSpreadsheet = updatedSpreadsheet;
    return this;
  }

  @Override
  public BatchUpdateSpreadsheetResponse set(String fieldName, Object value) {
    return (BatchUpdateSpreadsheetResponse) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateSpreadsheetResponse clone() {
    return (BatchUpdateSpreadsheetResponse) super.clone();
  }

}
