/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-22 at 00:35:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Adds new cells after the last row with data in a sheet, inserting new rows into the sheet if
 * necessary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppendCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The data to append.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RowData> rows;

  /**
   * The sheet ID to append the data to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * @param fields fields or {@code null} for none
   */
  public AppendCellsRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The data to append.
   * @return value or {@code null} for none
   */
  public java.util.List<RowData> getRows() {
    return rows;
  }

  /**
   * The data to append.
   * @param rows rows or {@code null} for none
   */
  public AppendCellsRequest setRows(java.util.List<RowData> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * The sheet ID to append the data to.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet ID to append the data to.
   * @param sheetId sheetId or {@code null} for none
   */
  public AppendCellsRequest setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  @Override
  public AppendCellsRequest set(String fieldName, Object value) {
    return (AppendCellsRequest) super.set(fieldName, value);
  }

  @Override
  public AppendCellsRequest clone() {
    return (AppendCellsRequest) super.clone();
  }

}
