/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-23 at 00:57:33 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A run of a text format. The format of this run continues until the start index of the next run.
 * When updating, all fields must be set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextFormatRun extends com.google.api.client.json.GenericJson {

  /**
   * The format of this run.  Absent values inherit the cell's format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextFormat format;

  /**
   * The character index where this run starts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The format of this run.  Absent values inherit the cell's format.
   * @return value or {@code null} for none
   */
  public TextFormat getFormat() {
    return format;
  }

  /**
   * The format of this run.  Absent values inherit the cell's format.
   * @param format format or {@code null} for none
   */
  public TextFormatRun setFormat(TextFormat format) {
    this.format = format;
    return this;
  }

  /**
   * The character index where this run starts.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The character index where this run starts.
   * @param startIndex startIndex or {@code null} for none
   */
  public TextFormatRun setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  @Override
  public TextFormatRun set(String fieldName, Object value) {
    return (TextFormatRun) super.set(fieldName, value);
  }

  @Override
  public TextFormatRun clone() {
    return (TextFormatRun) super.clone();
  }

}
