/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-02-22 at 20:33:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Adds a new banded range to the spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddBandingRequest extends com.google.api.client.json.GenericJson {

  /**
   * The banded range to add. The bandedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BandedRange bandedRange;

  /**
   * The banded range to add. The bandedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * @return value or {@code null} for none
   */
  public BandedRange getBandedRange() {
    return bandedRange;
  }

  /**
   * The banded range to add. The bandedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * @param bandedRange bandedRange or {@code null} for none
   */
  public AddBandingRequest setBandedRange(BandedRange bandedRange) {
    this.bandedRange = bandedRange;
    return this;
  }

  @Override
  public AddBandingRequest set(String fieldName, Object value) {
    return (AddBandingRequest) super.set(fieldName, value);
  }

  @Override
  public AddBandingRequest clone() {
    return (AddBandingRequest) super.clone();
  }

}
