/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-02-22 at 20:33:44 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The specifications of a chart.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChartSpec extends com.google.api.client.json.GenericJson {

  /**
   * A basic chart specification, can be one of many kinds of charts. See BasicChartType for the
   * list of all charts this supports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicChartSpec basicChart;

  /**
   * Determines how the charts will use hidden rows or columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hiddenDimensionStrategy;

  /**
   * A pie chart specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PieChartSpec pieChart;

  /**
   * The title of the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * A basic chart specification, can be one of many kinds of charts. See BasicChartType for the
   * list of all charts this supports.
   * @return value or {@code null} for none
   */
  public BasicChartSpec getBasicChart() {
    return basicChart;
  }

  /**
   * A basic chart specification, can be one of many kinds of charts. See BasicChartType for the
   * list of all charts this supports.
   * @param basicChart basicChart or {@code null} for none
   */
  public ChartSpec setBasicChart(BasicChartSpec basicChart) {
    this.basicChart = basicChart;
    return this;
  }

  /**
   * Determines how the charts will use hidden rows or columns.
   * @return value or {@code null} for none
   */
  public java.lang.String getHiddenDimensionStrategy() {
    return hiddenDimensionStrategy;
  }

  /**
   * Determines how the charts will use hidden rows or columns.
   * @param hiddenDimensionStrategy hiddenDimensionStrategy or {@code null} for none
   */
  public ChartSpec setHiddenDimensionStrategy(java.lang.String hiddenDimensionStrategy) {
    this.hiddenDimensionStrategy = hiddenDimensionStrategy;
    return this;
  }

  /**
   * A pie chart specification.
   * @return value or {@code null} for none
   */
  public PieChartSpec getPieChart() {
    return pieChart;
  }

  /**
   * A pie chart specification.
   * @param pieChart pieChart or {@code null} for none
   */
  public ChartSpec setPieChart(PieChartSpec pieChart) {
    this.pieChart = pieChart;
    return this;
  }

  /**
   * The title of the chart.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of the chart.
   * @param title title or {@code null} for none
   */
  public ChartSpec setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public ChartSpec set(String fieldName, Object value) {
    return (ChartSpec) super.set(fieldName, value);
  }

  @Override
  public ChartSpec clone() {
    return (ChartSpec) super.clone();
  }

}
