/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-10 at 21:58:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A single grouping (either row or column) in a pivot table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotGroup extends com.google.api.client.json.GenericJson {

  /**
   * True if the pivot table should include the totals for this grouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showTotals;

  /**
   * The order the values in this group should be sorted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sortOrder;

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sourceColumnOffset;

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PivotGroupSortValueBucket valueBucket;

  /**
   * Metadata about values in the grouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PivotGroupValueMetadata> valueMetadata;

  /**
   * True if the pivot table should include the totals for this grouping.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowTotals() {
    return showTotals;
  }

  /**
   * True if the pivot table should include the totals for this grouping.
   * @param showTotals showTotals or {@code null} for none
   */
  public PivotGroup setShowTotals(java.lang.Boolean showTotals) {
    this.showTotals = showTotals;
    return this;
  }

  /**
   * The order the values in this group should be sorted.
   * @return value or {@code null} for none
   */
  public java.lang.String getSortOrder() {
    return sortOrder;
  }

  /**
   * The order the values in this group should be sorted.
   * @param sortOrder sortOrder or {@code null} for none
   */
  public PivotGroup setSortOrder(java.lang.String sortOrder) {
    this.sortOrder = sortOrder;
    return this;
  }

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSourceColumnOffset() {
    return sourceColumnOffset;
  }

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * @param sourceColumnOffset sourceColumnOffset or {@code null} for none
   */
  public PivotGroup setSourceColumnOffset(java.lang.Integer sourceColumnOffset) {
    this.sourceColumnOffset = sourceColumnOffset;
    return this;
  }

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * @return value or {@code null} for none
   */
  public PivotGroupSortValueBucket getValueBucket() {
    return valueBucket;
  }

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * @param valueBucket valueBucket or {@code null} for none
   */
  public PivotGroup setValueBucket(PivotGroupSortValueBucket valueBucket) {
    this.valueBucket = valueBucket;
    return this;
  }

  /**
   * Metadata about values in the grouping.
   * @return value or {@code null} for none
   */
  public java.util.List<PivotGroupValueMetadata> getValueMetadata() {
    return valueMetadata;
  }

  /**
   * Metadata about values in the grouping.
   * @param valueMetadata valueMetadata or {@code null} for none
   */
  public PivotGroup setValueMetadata(java.util.List<PivotGroupValueMetadata> valueMetadata) {
    this.valueMetadata = valueMetadata;
    return this;
  }

  @Override
  public PivotGroup set(String fieldName, Object value) {
    return (PivotGroup) super.set(fieldName, value);
  }

  @Override
  public PivotGroup clone() {
    return (PivotGroup) super.clone();
  }

}
