/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-08-02 at 20:35:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Source ranges for a chart.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChartSourceRange extends com.google.api.client.json.GenericJson {

  /**
   * The ranges of data for a series or domain. Exactly one dimension must have a length of 1, and
   * all sources in the list must have the same dimension with length 1. The domain (if it exists) &
   * all series must have the same number of source ranges. If using more than one source range,
   * then the source range at a given offset must be contiguous across the domain and series.
   *
   * For example, these are valid configurations:
   *
   *     domain sources: A1:A5     series1 sources: B1:B5     series2 sources: D6:D10
   *
   *     domain sources: A1:A5, C10:C12     series1 sources: B1:B5, D10:D12     series2 sources:
   * C1:C5, E10:E12
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GridRange> sources;

  /**
   * The ranges of data for a series or domain. Exactly one dimension must have a length of 1, and
   * all sources in the list must have the same dimension with length 1. The domain (if it exists) &
   * all series must have the same number of source ranges. If using more than one source range,
   * then the source range at a given offset must be contiguous across the domain and series.
   *
   * For example, these are valid configurations:
   *
   *     domain sources: A1:A5     series1 sources: B1:B5     series2 sources: D6:D10
   *
   *     domain sources: A1:A5, C10:C12     series1 sources: B1:B5, D10:D12     series2 sources:
   * C1:C5, E10:E12
   * @return value or {@code null} for none
   */
  public java.util.List<GridRange> getSources() {
    return sources;
  }

  /**
   * The ranges of data for a series or domain. Exactly one dimension must have a length of 1, and
   * all sources in the list must have the same dimension with length 1. The domain (if it exists) &
   * all series must have the same number of source ranges. If using more than one source range,
   * then the source range at a given offset must be contiguous across the domain and series.
   *
   * For example, these are valid configurations:
   *
   *     domain sources: A1:A5     series1 sources: B1:B5     series2 sources: D6:D10
   *
   *     domain sources: A1:A5, C10:C12     series1 sources: B1:B5, D10:D12     series2 sources:
   * C1:C5, E10:E12
   * @param sources sources or {@code null} for none
   */
  public ChartSourceRange setSources(java.util.List<GridRange> sources) {
    this.sources = sources;
    return this;
  }

  @Override
  public ChartSourceRange set(String fieldName, Object value) {
    return (ChartSourceRange) super.set(fieldName, value);
  }

  @Override
  public ChartSourceRange clone() {
    return (ChartSourceRange) super.clone();
  }

}
