/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-11-01 at 20:42:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Adds a new conditional format rule at the given index. All subsequent rules' indexes are
 * incremented.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddConditionalFormatRuleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The zero-based index where the rule should be inserted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * The rule to add.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConditionalFormatRule rule;

  /**
   * The zero-based index where the rule should be inserted.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * The zero-based index where the rule should be inserted.
   * @param index index or {@code null} for none
   */
  public AddConditionalFormatRuleRequest setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * The rule to add.
   * @return value or {@code null} for none
   */
  public ConditionalFormatRule getRule() {
    return rule;
  }

  /**
   * The rule to add.
   * @param rule rule or {@code null} for none
   */
  public AddConditionalFormatRuleRequest setRule(ConditionalFormatRule rule) {
    this.rule = rule;
    return this;
  }

  @Override
  public AddConditionalFormatRuleRequest set(String fieldName, Object value) {
    return (AddConditionalFormatRuleRequest) super.set(fieldName, value);
  }

  @Override
  public AddConditionalFormatRuleRequest clone() {
    return (AddConditionalFormatRuleRequest) super.clone();
  }

}
