/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-14 at 18:49:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The response when retrieving more than one range of values in a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchGetValuesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the spreadsheet the data was retrieved from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spreadsheetId;

  /**
   * The requested values. The order of the ValueRanges is the same as the order of the requested
   * ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueRange> valueRanges;

  /**
   * The ID of the spreadsheet the data was retrieved from.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpreadsheetId() {
    return spreadsheetId;
  }

  /**
   * The ID of the spreadsheet the data was retrieved from.
   * @param spreadsheetId spreadsheetId or {@code null} for none
   */
  public BatchGetValuesResponse setSpreadsheetId(java.lang.String spreadsheetId) {
    this.spreadsheetId = spreadsheetId;
    return this;
  }

  /**
   * The requested values. The order of the ValueRanges is the same as the order of the requested
   * ranges.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueRange> getValueRanges() {
    return valueRanges;
  }

  /**
   * The requested values. The order of the ValueRanges is the same as the order of the requested
   * ranges.
   * @param valueRanges valueRanges or {@code null} for none
   */
  public BatchGetValuesResponse setValueRanges(java.util.List<ValueRange> valueRanges) {
    this.valueRanges = valueRanges;
    return this;
  }

  @Override
  public BatchGetValuesResponse set(String fieldName, Object value) {
    return (BatchGetValuesResponse) super.set(fieldName, value);
  }

  @Override
  public BatchGetValuesResponse clone() {
    return (BatchGetValuesResponse) super.clone();
  }

}
