/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-09 at 18:44:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A value range that was matched by one or more data filers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MatchedValueRange extends com.google.api.client.json.GenericJson {

  /**
   * The DataFilters from the request that matched the range of values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataFilter> dataFilters;

  /**
   * The values matched by the DataFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ValueRange valueRange;

  /**
   * The DataFilters from the request that matched the range of values.
   * @return value or {@code null} for none
   */
  public java.util.List<DataFilter> getDataFilters() {
    return dataFilters;
  }

  /**
   * The DataFilters from the request that matched the range of values.
   * @param dataFilters dataFilters or {@code null} for none
   */
  public MatchedValueRange setDataFilters(java.util.List<DataFilter> dataFilters) {
    this.dataFilters = dataFilters;
    return this;
  }

  /**
   * The values matched by the DataFilter.
   * @return value or {@code null} for none
   */
  public ValueRange getValueRange() {
    return valueRange;
  }

  /**
   * The values matched by the DataFilter.
   * @param valueRange valueRange or {@code null} for none
   */
  public MatchedValueRange setValueRange(ValueRange valueRange) {
    this.valueRange = valueRange;
    return this;
  }

  @Override
  public MatchedValueRange set(String fieldName, Object value) {
    return (MatchedValueRange) super.set(fieldName, value);
  }

  @Override
  public MatchedValueRange clone() {
    return (MatchedValueRange) super.clone();
  }

}
