/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-16 at 17:43:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Selects DeveloperMetadata that matches all of the specified fields.  For example, if only a
 * metadata ID is specified this considers the DeveloperMetadata with that particular unique ID. If
 * a metadata key is specified, this considers all developer metadata with that key.  If a key,
 * visibility, and location type are all specified, this considers all developer metadata with that
 * key and visibility that are associated with a location of that type.  In general, this selects
 * all DeveloperMetadata that matches the intersection of all the specified fields; any field or
 * combination of fields may be specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeveloperMetadataLookup extends com.google.api.client.json.GenericJson {

  /**
   * Determines how this lookup matches the location.  If this field is specified as EXACT, only
   * developer metadata associated on the exact location specified is matched.  If this field is
   * specified to INTERSECTING, developer metadata associated on intersecting locations is also
   * matched.  If left unspecified, this field assumes a default value of INTERSECTING. If this
   * field is specified, a metadataLocation must also be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationMatchingStrategy;

  /**
   * Limits the selected developer metadata to those entries which are associated with locations of
   * the specified type.  For example, when this field is specified as ROW this lookup only
   * considers developer metadata associated on rows.  If the field is left unspecified, all
   * location types are considered.  This field cannot be specified as SPREADSHEET when the
   * locationMatchingStrategy is specified as INTERSECTING or when the metadataLocation is specified
   * as a non-spreadsheet location: spreadsheet metadata cannot intersect any other developer
   * metadata location.  This field also must be left unspecified when the locationMatchingStrategy
   * is specified as EXACT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationType;

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer metadataId;

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataKey;

  /**
   * Limits the selected developer metadata to those entries associated with the specified location.
   * This field either matches exact locations or all intersecting locations according the specified
   * locationMatchingStrategy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeveloperMetadataLocation metadataLocation;

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataValue;

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.visibility.  If left unspecified, all developer metadata visibile to the
   * requesting project is considered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * Determines how this lookup matches the location.  If this field is specified as EXACT, only
   * developer metadata associated on the exact location specified is matched.  If this field is
   * specified to INTERSECTING, developer metadata associated on intersecting locations is also
   * matched.  If left unspecified, this field assumes a default value of INTERSECTING. If this
   * field is specified, a metadataLocation must also be specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationMatchingStrategy() {
    return locationMatchingStrategy;
  }

  /**
   * Determines how this lookup matches the location.  If this field is specified as EXACT, only
   * developer metadata associated on the exact location specified is matched.  If this field is
   * specified to INTERSECTING, developer metadata associated on intersecting locations is also
   * matched.  If left unspecified, this field assumes a default value of INTERSECTING. If this
   * field is specified, a metadataLocation must also be specified.
   * @param locationMatchingStrategy locationMatchingStrategy or {@code null} for none
   */
  public DeveloperMetadataLookup setLocationMatchingStrategy(java.lang.String locationMatchingStrategy) {
    this.locationMatchingStrategy = locationMatchingStrategy;
    return this;
  }

  /**
   * Limits the selected developer metadata to those entries which are associated with locations of
   * the specified type.  For example, when this field is specified as ROW this lookup only
   * considers developer metadata associated on rows.  If the field is left unspecified, all
   * location types are considered.  This field cannot be specified as SPREADSHEET when the
   * locationMatchingStrategy is specified as INTERSECTING or when the metadataLocation is specified
   * as a non-spreadsheet location: spreadsheet metadata cannot intersect any other developer
   * metadata location.  This field also must be left unspecified when the locationMatchingStrategy
   * is specified as EXACT.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationType() {
    return locationType;
  }

  /**
   * Limits the selected developer metadata to those entries which are associated with locations of
   * the specified type.  For example, when this field is specified as ROW this lookup only
   * considers developer metadata associated on rows.  If the field is left unspecified, all
   * location types are considered.  This field cannot be specified as SPREADSHEET when the
   * locationMatchingStrategy is specified as INTERSECTING or when the metadataLocation is specified
   * as a non-spreadsheet location: spreadsheet metadata cannot intersect any other developer
   * metadata location.  This field also must be left unspecified when the locationMatchingStrategy
   * is specified as EXACT.
   * @param locationType locationType or {@code null} for none
   */
  public DeveloperMetadataLookup setLocationType(java.lang.String locationType) {
    this.locationType = locationType;
    return this;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_id.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMetadataId() {
    return metadataId;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_id.
   * @param metadataId metadataId or {@code null} for none
   */
  public DeveloperMetadataLookup setMetadataId(java.lang.Integer metadataId) {
    this.metadataId = metadataId;
    return this;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_key.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataKey() {
    return metadataKey;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_key.
   * @param metadataKey metadataKey or {@code null} for none
   */
  public DeveloperMetadataLookup setMetadataKey(java.lang.String metadataKey) {
    this.metadataKey = metadataKey;
    return this;
  }

  /**
   * Limits the selected developer metadata to those entries associated with the specified location.
   * This field either matches exact locations or all intersecting locations according the specified
   * locationMatchingStrategy.
   * @return value or {@code null} for none
   */
  public DeveloperMetadataLocation getMetadataLocation() {
    return metadataLocation;
  }

  /**
   * Limits the selected developer metadata to those entries associated with the specified location.
   * This field either matches exact locations or all intersecting locations according the specified
   * locationMatchingStrategy.
   * @param metadataLocation metadataLocation or {@code null} for none
   */
  public DeveloperMetadataLookup setMetadataLocation(DeveloperMetadataLocation metadataLocation) {
    this.metadataLocation = metadataLocation;
    return this;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_value.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataValue() {
    return metadataValue;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.metadata_value.
   * @param metadataValue metadataValue or {@code null} for none
   */
  public DeveloperMetadataLookup setMetadataValue(java.lang.String metadataValue) {
    this.metadataValue = metadataValue;
    return this;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.visibility.  If left unspecified, all developer metadata visibile to the
   * requesting project is considered.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * Limits the selected developer metadata to that which has a matching
   * DeveloperMetadata.visibility.  If left unspecified, all developer metadata visibile to the
   * requesting project is considered.
   * @param visibility visibility or {@code null} for none
   */
  public DeveloperMetadataLookup setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public DeveloperMetadataLookup set(String fieldName, Object value) {
    return (DeveloperMetadataLookup) super.set(fieldName, value);
  }

  @Override
  public DeveloperMetadataLookup clone() {
    return (DeveloperMetadataLookup) super.clone();
  }

}
