/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-12 at 19:47:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A location where metadata may be associated in a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeveloperMetadataLocation extends com.google.api.client.json.GenericJson {

  /**
   * Represents the row or column when metadata is associated with a dimension. The specified
   * DimensionRange must represent a single row or column; it cannot be unbounded or span multiple
   * rows or columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange dimensionRange;

  /**
   * The type of location this object represents.  This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationType;

  /**
   * The ID of the sheet when metadata is associated with an entire sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * True when metadata is associated with an entire spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean spreadsheet;

  /**
   * Represents the row or column when metadata is associated with a dimension. The specified
   * DimensionRange must represent a single row or column; it cannot be unbounded or span multiple
   * rows or columns.
   * @return value or {@code null} for none
   */
  public DimensionRange getDimensionRange() {
    return dimensionRange;
  }

  /**
   * Represents the row or column when metadata is associated with a dimension. The specified
   * DimensionRange must represent a single row or column; it cannot be unbounded or span multiple
   * rows or columns.
   * @param dimensionRange dimensionRange or {@code null} for none
   */
  public DeveloperMetadataLocation setDimensionRange(DimensionRange dimensionRange) {
    this.dimensionRange = dimensionRange;
    return this;
  }

  /**
   * The type of location this object represents.  This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationType() {
    return locationType;
  }

  /**
   * The type of location this object represents.  This field is read-only.
   * @param locationType locationType or {@code null} for none
   */
  public DeveloperMetadataLocation setLocationType(java.lang.String locationType) {
    this.locationType = locationType;
    return this;
  }

  /**
   * The ID of the sheet when metadata is associated with an entire sheet.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The ID of the sheet when metadata is associated with an entire sheet.
   * @param sheetId sheetId or {@code null} for none
   */
  public DeveloperMetadataLocation setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  /**
   * True when metadata is associated with an entire spreadsheet.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSpreadsheet() {
    return spreadsheet;
  }

  /**
   * True when metadata is associated with an entire spreadsheet.
   * @param spreadsheet spreadsheet or {@code null} for none
   */
  public DeveloperMetadataLocation setSpreadsheet(java.lang.Boolean spreadsheet) {
    this.spreadsheet = spreadsheet;
    return this;
  }

  @Override
  public DeveloperMetadataLocation set(String fieldName, Object value) {
    return (DeveloperMetadataLocation) super.set(fieldName, value);
  }

  @Override
  public DeveloperMetadataLocation clone() {
    return (DeveloperMetadataLocation) super.clone();
  }

}
