/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-12 at 19:47:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Settings to control how circular dependencies are resolved with iterative calculation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IterativeCalculationSettings extends com.google.api.client.json.GenericJson {

  /**
   * When iterative calculation is enabled and successive results differ by less than this threshold
   * value, the calculation rounds stop.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double convergenceThreshold;

  /**
   * When iterative calculation is enabled, the maximum number of calculation rounds to perform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxIterations;

  /**
   * When iterative calculation is enabled and successive results differ by less than this threshold
   * value, the calculation rounds stop.
   * @return value or {@code null} for none
   */
  public java.lang.Double getConvergenceThreshold() {
    return convergenceThreshold;
  }

  /**
   * When iterative calculation is enabled and successive results differ by less than this threshold
   * value, the calculation rounds stop.
   * @param convergenceThreshold convergenceThreshold or {@code null} for none
   */
  public IterativeCalculationSettings setConvergenceThreshold(java.lang.Double convergenceThreshold) {
    this.convergenceThreshold = convergenceThreshold;
    return this;
  }

  /**
   * When iterative calculation is enabled, the maximum number of calculation rounds to perform.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxIterations() {
    return maxIterations;
  }

  /**
   * When iterative calculation is enabled, the maximum number of calculation rounds to perform.
   * @param maxIterations maxIterations or {@code null} for none
   */
  public IterativeCalculationSettings setMaxIterations(java.lang.Integer maxIterations) {
    this.maxIterations = maxIterations;
    return this;
  }

  @Override
  public IterativeCalculationSettings set(String fieldName, Object value) {
    return (IterativeCalculationSettings) super.set(fieldName, value);
  }

  @Override
  public IterativeCalculationSettings clone() {
    return (IterativeCalculationSettings) super.clone();
  }

}
