/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-14 at 19:21:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The rotation applied to text in a cell.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextRotation extends com.google.api.client.json.GenericJson {

  /**
   * The angle between the standard orientation and the desired orientation. Measured in degrees.
   * Valid values are between -90 and 90. Positive angles are angled upwards, negative are angled
   * downwards.
   *
   * Note: For LTR text direction positive angles are in the counterclockwise direction, whereas for
   * RTL they are in the clockwise direction
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer angle;

  /**
   * If true, text reads top to bottom, but the orientation of individual characters is unchanged.
   * For example:
   *
   *     | V |     | e |     | r |     | t |     | i |     | c |     | a |     | l |
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean vertical;

  /**
   * The angle between the standard orientation and the desired orientation. Measured in degrees.
   * Valid values are between -90 and 90. Positive angles are angled upwards, negative are angled
   * downwards.
   *
   * Note: For LTR text direction positive angles are in the counterclockwise direction, whereas for
   * RTL they are in the clockwise direction
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAngle() {
    return angle;
  }

  /**
   * The angle between the standard orientation and the desired orientation. Measured in degrees.
   * Valid values are between -90 and 90. Positive angles are angled upwards, negative are angled
   * downwards.
   *
   * Note: For LTR text direction positive angles are in the counterclockwise direction, whereas for
   * RTL they are in the clockwise direction
   * @param angle angle or {@code null} for none
   */
  public TextRotation setAngle(java.lang.Integer angle) {
    this.angle = angle;
    return this;
  }

  /**
   * If true, text reads top to bottom, but the orientation of individual characters is unchanged.
   * For example:
   *
   *     | V |     | e |     | r |     | t |     | i |     | c |     | a |     | l |
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVertical() {
    return vertical;
  }

  /**
   * If true, text reads top to bottom, but the orientation of individual characters is unchanged.
   * For example:
   *
   *     | V |     | e |     | r |     | t |     | i |     | c |     | a |     | l |
   * @param vertical vertical or {@code null} for none
   */
  public TextRotation setVertical(java.lang.Boolean vertical) {
    this.vertical = vertical;
    return this;
  }

  @Override
  public TextRotation set(String fieldName, Object value) {
    return (TextRotation) super.set(fieldName, value);
  }

  @Override
  public TextRotation clone() {
    return (TextRotation) super.clone();
  }

}
