/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-27 at 01:00:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates all cells in a range with new data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The range to write data to.
   *
   * If the data in rows does not cover the entire requested range, the fields matching those set in
   * fields will be cleared.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The data to write.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RowData> rows;

  static {
    // hack to force ProGuard to consider RowData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RowData.class);
  }

  /**
   * The coordinate to start writing data at. Any number of rows and columns (including a different
   * number of columns per row) may be written.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridCoordinate start;

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields of CellData that should be updated. At least one field must be specified. The root
   * is the CellData; 'row.values.' should not be specified. A single `"*"` can be used as short-
   * hand for listing every field.
   * @param fields fields or {@code null} for none
   */
  public UpdateCellsRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The range to write data to.
   *
   * If the data in rows does not cover the entire requested range, the fields matching those set in
   * fields will be cleared.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range to write data to.
   *
   * If the data in rows does not cover the entire requested range, the fields matching those set in
   * fields will be cleared.
   * @param range range or {@code null} for none
   */
  public UpdateCellsRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The data to write.
   * @return value or {@code null} for none
   */
  public java.util.List<RowData> getRows() {
    return rows;
  }

  /**
   * The data to write.
   * @param rows rows or {@code null} for none
   */
  public UpdateCellsRequest setRows(java.util.List<RowData> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * The coordinate to start writing data at. Any number of rows and columns (including a different
   * number of columns per row) may be written.
   * @return value or {@code null} for none
   */
  public GridCoordinate getStart() {
    return start;
  }

  /**
   * The coordinate to start writing data at. Any number of rows and columns (including a different
   * number of columns per row) may be written.
   * @param start start or {@code null} for none
   */
  public UpdateCellsRequest setStart(GridCoordinate start) {
    this.start = start;
    return this;
  }

  @Override
  public UpdateCellsRequest set(String fieldName, Object value) {
    return (UpdateCellsRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateCellsRequest clone() {
    return (UpdateCellsRequest) super.clone();
  }

}
