/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-04 at 02:49:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Merges all cells in the range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MergeCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * How the cells should be merged.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mergeType;

  /**
   * The range of cells to merge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * How the cells should be merged.
   * @return value or {@code null} for none
   */
  public java.lang.String getMergeType() {
    return mergeType;
  }

  /**
   * How the cells should be merged.
   * @param mergeType mergeType or {@code null} for none
   */
  public MergeCellsRequest setMergeType(java.lang.String mergeType) {
    this.mergeType = mergeType;
    return this;
  }

  /**
   * The range of cells to merge.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range of cells to merge.
   * @param range range or {@code null} for none
   */
  public MergeCellsRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  @Override
  public MergeCellsRequest set(String fieldName, Object value) {
    return (MergeCellsRequest) super.set(fieldName, value);
  }

  @Override
  public MergeCellsRequest clone() {
    return (MergeCellsRequest) super.clone();
  }

}
