/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-25 at 21:07:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The result of updating a conditional format rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateConditionalFormatRuleResponse extends com.google.api.client.json.GenericJson {

  /**
   * The index of the new rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer newIndex;

  /**
   * The new rule that replaced the old rule (if replacing), or the rule that was moved (if moved)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConditionalFormatRule newRule;

  /**
   * The old index of the rule. Not set if a rule was replaced (because it is the same as
   * new_index).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer oldIndex;

  /**
   * The old (deleted) rule. Not set if a rule was moved (because it is the same as new_rule).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConditionalFormatRule oldRule;

  /**
   * The index of the new rule.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNewIndex() {
    return newIndex;
  }

  /**
   * The index of the new rule.
   * @param newIndex newIndex or {@code null} for none
   */
  public UpdateConditionalFormatRuleResponse setNewIndex(java.lang.Integer newIndex) {
    this.newIndex = newIndex;
    return this;
  }

  /**
   * The new rule that replaced the old rule (if replacing), or the rule that was moved (if moved)
   * @return value or {@code null} for none
   */
  public ConditionalFormatRule getNewRule() {
    return newRule;
  }

  /**
   * The new rule that replaced the old rule (if replacing), or the rule that was moved (if moved)
   * @param newRule newRule or {@code null} for none
   */
  public UpdateConditionalFormatRuleResponse setNewRule(ConditionalFormatRule newRule) {
    this.newRule = newRule;
    return this;
  }

  /**
   * The old index of the rule. Not set if a rule was replaced (because it is the same as
   * new_index).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOldIndex() {
    return oldIndex;
  }

  /**
   * The old index of the rule. Not set if a rule was replaced (because it is the same as
   * new_index).
   * @param oldIndex oldIndex or {@code null} for none
   */
  public UpdateConditionalFormatRuleResponse setOldIndex(java.lang.Integer oldIndex) {
    this.oldIndex = oldIndex;
    return this;
  }

  /**
   * The old (deleted) rule. Not set if a rule was moved (because it is the same as new_rule).
   * @return value or {@code null} for none
   */
  public ConditionalFormatRule getOldRule() {
    return oldRule;
  }

  /**
   * The old (deleted) rule. Not set if a rule was moved (because it is the same as new_rule).
   * @param oldRule oldRule or {@code null} for none
   */
  public UpdateConditionalFormatRuleResponse setOldRule(ConditionalFormatRule oldRule) {
    this.oldRule = oldRule;
    return this;
  }

  @Override
  public UpdateConditionalFormatRuleResponse set(String fieldName, Object value) {
    return (UpdateConditionalFormatRuleResponse) super.set(fieldName, value);
  }

  @Override
  public UpdateConditionalFormatRuleResponse clone() {
    return (UpdateConditionalFormatRuleResponse) super.clone();
  }

}
