/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-26 at 23:18:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Update an embedded object's position (such as a moving or resizing a chart or image).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateEmbeddedObjectPositionRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields of OverlayPosition that should be updated when setting a new position. Used only if
   * newPosition.overlayPosition is set, in which case at least one field must be specified.  The
   * root `newPosition.overlayPosition` is implied and should not be specified. A single `"*"` can
   * be used as short-hand for listing every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * An explicit position to move the embedded object to. If newPosition.sheetId is set, a new sheet
   * with that ID will be created. If newPosition.newSheet is set to true, a new sheet will be
   * created with an ID that will be chosen for you.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedObjectPosition newPosition;

  /**
   * The ID of the object to moved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer objectId;

  /**
   * The fields of OverlayPosition that should be updated when setting a new position. Used only if
   * newPosition.overlayPosition is set, in which case at least one field must be specified.  The
   * root `newPosition.overlayPosition` is implied and should not be specified. A single `"*"` can
   * be used as short-hand for listing every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields of OverlayPosition that should be updated when setting a new position. Used only if
   * newPosition.overlayPosition is set, in which case at least one field must be specified.  The
   * root `newPosition.overlayPosition` is implied and should not be specified. A single `"*"` can
   * be used as short-hand for listing every field.
   * @param fields fields or {@code null} for none
   */
  public UpdateEmbeddedObjectPositionRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * An explicit position to move the embedded object to. If newPosition.sheetId is set, a new sheet
   * with that ID will be created. If newPosition.newSheet is set to true, a new sheet will be
   * created with an ID that will be chosen for you.
   * @return value or {@code null} for none
   */
  public EmbeddedObjectPosition getNewPosition() {
    return newPosition;
  }

  /**
   * An explicit position to move the embedded object to. If newPosition.sheetId is set, a new sheet
   * with that ID will be created. If newPosition.newSheet is set to true, a new sheet will be
   * created with an ID that will be chosen for you.
   * @param newPosition newPosition or {@code null} for none
   */
  public UpdateEmbeddedObjectPositionRequest setNewPosition(EmbeddedObjectPosition newPosition) {
    this.newPosition = newPosition;
    return this;
  }

  /**
   * The ID of the object to moved.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getObjectId() {
    return objectId;
  }

  /**
   * The ID of the object to moved.
   * @param objectId objectId or {@code null} for none
   */
  public UpdateEmbeddedObjectPositionRequest setObjectId(java.lang.Integer objectId) {
    this.objectId = objectId;
    return this;
  }

  @Override
  public UpdateEmbeddedObjectPositionRequest set(String fieldName, Object value) {
    return (UpdateEmbeddedObjectPositionRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateEmbeddedObjectPositionRequest clone() {
    return (UpdateEmbeddedObjectPositionRequest) super.clone();
  }

}
