/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-09 at 23:09:42 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The amount of padding around the cell, in pixels. When updating padding, every field must be
 * specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Padding extends com.google.api.client.json.GenericJson {

  /**
   * The bottom padding of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer bottom;

  /**
   * The left padding of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer left;

  /**
   * The right padding of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer right;

  /**
   * The top padding of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer top;

  /**
   * The bottom padding of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBottom() {
    return bottom;
  }

  /**
   * The bottom padding of the cell.
   * @param bottom bottom or {@code null} for none
   */
  public Padding setBottom(java.lang.Integer bottom) {
    this.bottom = bottom;
    return this;
  }

  /**
   * The left padding of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLeft() {
    return left;
  }

  /**
   * The left padding of the cell.
   * @param left left or {@code null} for none
   */
  public Padding setLeft(java.lang.Integer left) {
    this.left = left;
    return this;
  }

  /**
   * The right padding of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRight() {
    return right;
  }

  /**
   * The right padding of the cell.
   * @param right right or {@code null} for none
   */
  public Padding setRight(java.lang.Integer right) {
    this.right = right;
    return this;
  }

  /**
   * The top padding of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTop() {
    return top;
  }

  /**
   * The top padding of the cell.
   * @param top top or {@code null} for none
   */
  public Padding setTop(java.lang.Integer top) {
    this.top = top;
    return this;
  }

  @Override
  public Padding set(String fieldName, Object value) {
    return (Padding) super.set(fieldName, value);
  }

  @Override
  public Padding clone() {
    return (Padding) super.clone();
  }

}
