/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-26 at 06:45:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A banded (alternating colors) range in a sheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BandedRange extends com.google.api.client.json.GenericJson {

  /**
   * The id of the banded range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer bandedRangeId;

  /**
   * Properties for column bands. These properties are applied on a column- by-column basis
   * throughout all the columns in the range. At least one of row_properties or column_properties
   * must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BandingProperties columnProperties;

  /**
   * The range over which these properties are applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * Properties for row bands. These properties are applied on a row-by-row basis throughout all the
   * rows in the range. At least one of row_properties or column_properties must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BandingProperties rowProperties;

  /**
   * The id of the banded range.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBandedRangeId() {
    return bandedRangeId;
  }

  /**
   * The id of the banded range.
   * @param bandedRangeId bandedRangeId or {@code null} for none
   */
  public BandedRange setBandedRangeId(java.lang.Integer bandedRangeId) {
    this.bandedRangeId = bandedRangeId;
    return this;
  }

  /**
   * Properties for column bands. These properties are applied on a column- by-column basis
   * throughout all the columns in the range. At least one of row_properties or column_properties
   * must be specified.
   * @return value or {@code null} for none
   */
  public BandingProperties getColumnProperties() {
    return columnProperties;
  }

  /**
   * Properties for column bands. These properties are applied on a column- by-column basis
   * throughout all the columns in the range. At least one of row_properties or column_properties
   * must be specified.
   * @param columnProperties columnProperties or {@code null} for none
   */
  public BandedRange setColumnProperties(BandingProperties columnProperties) {
    this.columnProperties = columnProperties;
    return this;
  }

  /**
   * The range over which these properties are applied.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range over which these properties are applied.
   * @param range range or {@code null} for none
   */
  public BandedRange setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * Properties for row bands. These properties are applied on a row-by-row basis throughout all the
   * rows in the range. At least one of row_properties or column_properties must be specified.
   * @return value or {@code null} for none
   */
  public BandingProperties getRowProperties() {
    return rowProperties;
  }

  /**
   * Properties for row bands. These properties are applied on a row-by-row basis throughout all the
   * rows in the range. At least one of row_properties or column_properties must be specified.
   * @param rowProperties rowProperties or {@code null} for none
   */
  public BandedRange setRowProperties(BandingProperties rowProperties) {
    this.rowProperties = rowProperties;
    return this;
  }

  @Override
  public BandedRange set(String fieldName, Object value) {
    return (BandedRange) super.set(fieldName, value);
  }

  @Override
  public BandedRange clone() {
    return (BandedRange) super.clone();
  }

}
