/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-27 at 20:01:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The response when updating a range of values by a data filter in a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateValuesByDataFilterResponse extends com.google.api.client.json.GenericJson {

  /**
   * The data filter that selected the range that was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataFilter dataFilter;

  /**
   * The number of cells updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer updatedCells;

  /**
   * The number of columns where at least one cell in the column was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer updatedColumns;

  /**
   * The values of the cells in the range matched by the dataFilter after all updates were applied.
   * This is only included if the request's `includeValuesInResponse` field was `true`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ValueRange updatedData;

  /**
   * The range (in A1 notation) that updates were applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updatedRange;

  /**
   * The number of rows where at least one cell in the row was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer updatedRows;

  /**
   * The data filter that selected the range that was updated.
   * @return value or {@code null} for none
   */
  public DataFilter getDataFilter() {
    return dataFilter;
  }

  /**
   * The data filter that selected the range that was updated.
   * @param dataFilter dataFilter or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setDataFilter(DataFilter dataFilter) {
    this.dataFilter = dataFilter;
    return this;
  }

  /**
   * The number of cells updated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUpdatedCells() {
    return updatedCells;
  }

  /**
   * The number of cells updated.
   * @param updatedCells updatedCells or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setUpdatedCells(java.lang.Integer updatedCells) {
    this.updatedCells = updatedCells;
    return this;
  }

  /**
   * The number of columns where at least one cell in the column was updated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUpdatedColumns() {
    return updatedColumns;
  }

  /**
   * The number of columns where at least one cell in the column was updated.
   * @param updatedColumns updatedColumns or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setUpdatedColumns(java.lang.Integer updatedColumns) {
    this.updatedColumns = updatedColumns;
    return this;
  }

  /**
   * The values of the cells in the range matched by the dataFilter after all updates were applied.
   * This is only included if the request's `includeValuesInResponse` field was `true`.
   * @return value or {@code null} for none
   */
  public ValueRange getUpdatedData() {
    return updatedData;
  }

  /**
   * The values of the cells in the range matched by the dataFilter after all updates were applied.
   * This is only included if the request's `includeValuesInResponse` field was `true`.
   * @param updatedData updatedData or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setUpdatedData(ValueRange updatedData) {
    this.updatedData = updatedData;
    return this;
  }

  /**
   * The range (in A1 notation) that updates were applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdatedRange() {
    return updatedRange;
  }

  /**
   * The range (in A1 notation) that updates were applied to.
   * @param updatedRange updatedRange or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setUpdatedRange(java.lang.String updatedRange) {
    this.updatedRange = updatedRange;
    return this;
  }

  /**
   * The number of rows where at least one cell in the row was updated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUpdatedRows() {
    return updatedRows;
  }

  /**
   * The number of rows where at least one cell in the row was updated.
   * @param updatedRows updatedRows or {@code null} for none
   */
  public UpdateValuesByDataFilterResponse setUpdatedRows(java.lang.Integer updatedRows) {
    this.updatedRows = updatedRows;
    return this;
  }

  @Override
  public UpdateValuesByDataFilterResponse set(String fieldName, Object value) {
    return (UpdateValuesByDataFilterResponse) super.set(fieldName, value);
  }

  @Override
  public UpdateValuesByDataFilterResponse clone() {
    return (UpdateValuesByDataFilterResponse) super.clone();
  }

}
