/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-11 at 05:16:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates a chart's specifications. (This does not move or resize a chart. To move or resize a
 * chart, use  UpdateEmbeddedObjectPositionRequest.)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateChartSpecRequest extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the chart to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer chartId;

  /**
   * The specification to apply to the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartSpec spec;

  /**
   * The ID of the chart to update.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getChartId() {
    return chartId;
  }

  /**
   * The ID of the chart to update.
   * @param chartId chartId or {@code null} for none
   */
  public UpdateChartSpecRequest setChartId(java.lang.Integer chartId) {
    this.chartId = chartId;
    return this;
  }

  /**
   * The specification to apply to the chart.
   * @return value or {@code null} for none
   */
  public ChartSpec getSpec() {
    return spec;
  }

  /**
   * The specification to apply to the chart.
   * @param spec spec or {@code null} for none
   */
  public UpdateChartSpecRequest setSpec(ChartSpec spec) {
    this.spec = spec;
    return this;
  }

  @Override
  public UpdateChartSpecRequest set(String fieldName, Object value) {
    return (UpdateChartSpecRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateChartSpecRequest clone() {
    return (UpdateChartSpecRequest) super.clone();
  }

}
