/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-17 at 19:35:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Creates a group over the specified range.
 *
 * If the requested range is a superset of the range of an existing group G, then the depth of G is
 * incremented and this new group G' has the depth of that group. For example, a group [C:D, depth
 * 1] + [B:E] results in groups [B:E, depth 1] and [C:D, depth 2]. If the requested range is a
 * subset of the range of an existing group G, then the depth of the new group G' becomes one
 * greater than the depth of G. For example, a group [B:E, depth 1] + [C:D] results in groups [B:E,
 * depth 1] and [C:D, depth 2]. If the requested range starts before and ends within, or starts
 * within and ends after, the range of an existing group G, then the range of the existing group G
 * becomes the union of the ranges, and the new group G' has depth one greater than the depth of G
 * and range as the intersection of the ranges. For example, a group [B:D, depth 1] + [C:E] results
 * in groups [B:E, depth 1] and [C:D, depth 2].
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddDimensionGroupRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range over which to create a group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange range;

  /**
   * The range over which to create a group.
   * @return value or {@code null} for none
   */
  public DimensionRange getRange() {
    return range;
  }

  /**
   * The range over which to create a group.
   * @param range range or {@code null} for none
   */
  public AddDimensionGroupRequest setRange(DimensionRange range) {
    this.range = range;
    return this;
  }

  @Override
  public AddDimensionGroupRequest set(String fieldName, Object value) {
    return (AddDimensionGroupRequest) super.set(fieldName, value);
  }

  @Override
  public AddDimensionGroupRequest clone() {
    return (AddDimensionGroupRequest) super.clone();
  }

}
