/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-17 at 19:35:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The kinds of value that a cell in a spreadsheet can have.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExtendedValue extends com.google.api.client.json.GenericJson {

  /**
   * Represents a boolean value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean boolValue;

  /**
   * Represents an error. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ErrorValue errorValue;

  /**
   * Represents a formula.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formulaValue;

  /**
   * Represents a double value. Note: Dates, Times and DateTimes are represented as doubles in
   * "serial number" format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double numberValue;

  /**
   * Represents a string value. Leading single quotes are not included. For example, if the user
   * typed `'123` into the UI, this would be represented as a `stringValue` of `"123"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stringValue;

  /**
   * Represents a boolean value.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBoolValue() {
    return boolValue;
  }

  /**
   * Represents a boolean value.
   * @param boolValue boolValue or {@code null} for none
   */
  public ExtendedValue setBoolValue(java.lang.Boolean boolValue) {
    this.boolValue = boolValue;
    return this;
  }

  /**
   * Represents an error. This field is read-only.
   * @return value or {@code null} for none
   */
  public ErrorValue getErrorValue() {
    return errorValue;
  }

  /**
   * Represents an error. This field is read-only.
   * @param errorValue errorValue or {@code null} for none
   */
  public ExtendedValue setErrorValue(ErrorValue errorValue) {
    this.errorValue = errorValue;
    return this;
  }

  /**
   * Represents a formula.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormulaValue() {
    return formulaValue;
  }

  /**
   * Represents a formula.
   * @param formulaValue formulaValue or {@code null} for none
   */
  public ExtendedValue setFormulaValue(java.lang.String formulaValue) {
    this.formulaValue = formulaValue;
    return this;
  }

  /**
   * Represents a double value. Note: Dates, Times and DateTimes are represented as doubles in
   * "serial number" format.
   * @return value or {@code null} for none
   */
  public java.lang.Double getNumberValue() {
    return numberValue;
  }

  /**
   * Represents a double value. Note: Dates, Times and DateTimes are represented as doubles in
   * "serial number" format.
   * @param numberValue numberValue or {@code null} for none
   */
  public ExtendedValue setNumberValue(java.lang.Double numberValue) {
    this.numberValue = numberValue;
    return this;
  }

  /**
   * Represents a string value. Leading single quotes are not included. For example, if the user
   * typed `'123` into the UI, this would be represented as a `stringValue` of `"123"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getStringValue() {
    return stringValue;
  }

  /**
   * Represents a string value. Leading single quotes are not included. For example, if the user
   * typed `'123` into the UI, this would be represented as a `stringValue` of `"123"`.
   * @param stringValue stringValue or {@code null} for none
   */
  public ExtendedValue setStringValue(java.lang.String stringValue) {
    this.stringValue = stringValue;
    return this;
  }

  @Override
  public ExtendedValue set(String fieldName, Object value) {
    return (ExtendedValue) super.set(fieldName, value);
  }

  @Override
  public ExtendedValue clone() {
    return (ExtendedValue) super.clone();
  }

}
