/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-24 at 20:48:51 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A range on a sheet. All indexes are zero-based. Indexes are half open, e.g the start index is
 * inclusive and the end index is exclusive -- [start_index, end_index). Missing indexes indicate
 * the range is unbounded on that side.
 *
 * For example, if `"Sheet1"` is sheet ID 0, then:
 *
 *   `Sheet1!A1:A1 == sheet_id: 0,                   start_row_index: 0, end_row_index: 1,
 * start_column_index: 0, end_column_index: 1`
 *
 *   `Sheet1!A3:B4 == sheet_id: 0,                   start_row_index: 2, end_row_index: 4,
 * start_column_index: 0, end_column_index: 2`
 *
 *   `Sheet1!A:B == sheet_id: 0,                 start_column_index: 0, end_column_index: 2`
 *
 *   `Sheet1!A5:B == sheet_id: 0,                  start_row_index: 4,
 * start_column_index: 0, end_column_index: 2`
 *
 *   `Sheet1 == sheet_id:0`
 *
 * The start index must always be less than or equal to the end index. If the start index equals the
 * end index, then the range is empty. Empty ranges are typically not meaningful and are usually
 * rendered in the UI as `#REF!`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GridRange extends com.google.api.client.json.GenericJson {

  /**
   * The end column (exclusive) of the range, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endColumnIndex;

  /**
   * The end row (exclusive) of the range, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endRowIndex;

  /**
   * The sheet this range is on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * The start column (inclusive) of the range, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startColumnIndex;

  /**
   * The start row (inclusive) of the range, or not set if unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startRowIndex;

  /**
   * The end column (exclusive) of the range, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndColumnIndex() {
    return endColumnIndex;
  }

  /**
   * The end column (exclusive) of the range, or not set if unbounded.
   * @param endColumnIndex endColumnIndex or {@code null} for none
   */
  public GridRange setEndColumnIndex(java.lang.Integer endColumnIndex) {
    this.endColumnIndex = endColumnIndex;
    return this;
  }

  /**
   * The end row (exclusive) of the range, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndRowIndex() {
    return endRowIndex;
  }

  /**
   * The end row (exclusive) of the range, or not set if unbounded.
   * @param endRowIndex endRowIndex or {@code null} for none
   */
  public GridRange setEndRowIndex(java.lang.Integer endRowIndex) {
    this.endRowIndex = endRowIndex;
    return this;
  }

  /**
   * The sheet this range is on.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet this range is on.
   * @param sheetId sheetId or {@code null} for none
   */
  public GridRange setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  /**
   * The start column (inclusive) of the range, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartColumnIndex() {
    return startColumnIndex;
  }

  /**
   * The start column (inclusive) of the range, or not set if unbounded.
   * @param startColumnIndex startColumnIndex or {@code null} for none
   */
  public GridRange setStartColumnIndex(java.lang.Integer startColumnIndex) {
    this.startColumnIndex = startColumnIndex;
    return this;
  }

  /**
   * The start row (inclusive) of the range, or not set if unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartRowIndex() {
    return startRowIndex;
  }

  /**
   * The start row (inclusive) of the range, or not set if unbounded.
   * @param startRowIndex startRowIndex or {@code null} for none
   */
  public GridRange setStartRowIndex(java.lang.Integer startRowIndex) {
    this.startRowIndex = startRowIndex;
    return this;
  }

  @Override
  public GridRange set(String fieldName, Object value) {
    return (GridRange) super.set(fieldName, value);
  }

  @Override
  public GridRange clone() {
    return (GridRange) super.clone();
  }

}
