/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-10-01 at 19:54:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A Treemap chart.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TreemapChartSpec extends com.google.api.client.json.GenericJson {

  /**
   * The data that determines the background color of each treemap data cell. This field is
   * optional. If not specified, size_data is used to determine background colors. If specified, the
   * data is expected to be numeric. color_scale will determine how the values in this data map to
   * data cell background colors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData colorData;

  /**
   * The color scale for data cells in the treemap chart. Data cells are assigned colors based on
   * their color values. These color values come from color_data, or from size_data if color_data is
   * not specified. Cells with color values less than or equal to min_value will have minValueColor
   * as their background color. Cells with color values greater than or equal to max_value will have
   * maxValueColor as their background color. Cells with color values between min_value and
   * max_value will have background colors on a gradient between minValueColor and maxValueColor,
   * the midpoint of the gradient being midValueColor. Cells with missing or non-numeric color
   * values will have noDataColor as their background color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TreemapChartColorScale colorScale;

  /**
   * The background color for header cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color headerColor;

  /**
   * True to hide tooltips.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hideTooltips;

  /**
   * The number of additional data levels beyond the labeled levels to be shown on the treemap
   * chart. These levels are not interactive and are shown without their labels. Defaults to 0 if
   * not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer hintedLevels;

  /**
   * The data that contains the treemap cell labels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData labels;

  /**
   * The number of data levels to show on the treemap chart. These levels are interactive and are
   * shown with their labels. Defaults to 2 if not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer levels;

  /**
   * The maximum possible data value. Cells with values greater than this will have the same color
   * as cells with this value. If not specified, defaults to the actual maximum value from
   * color_data, or the maximum value from size_data if color_data is not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double maxValue;

  /**
   * The minimum possible data value. Cells with values less than this will have the same color as
   * cells with this value. If not specified, defaults to the actual minimum value from color_data,
   * or the minimum value from size_data if color_data is not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double minValue;

  /**
   * The data the contains the treemap cells' parent labels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData parentLabels;

  /**
   * The data that determines the size of each treemap data cell. This data is expected to be
   * numeric. The cells corresponding to non-numeric or missing data will not be rendered. If
   * color_data is not specified, this data is used to determine data cell background colors as
   * well.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData sizeData;

  /**
   * The text format for all labels on the chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextFormat textFormat;

  /**
   * The data that determines the background color of each treemap data cell. This field is
   * optional. If not specified, size_data is used to determine background colors. If specified, the
   * data is expected to be numeric. color_scale will determine how the values in this data map to
   * data cell background colors.
   * @return value or {@code null} for none
   */
  public ChartData getColorData() {
    return colorData;
  }

  /**
   * The data that determines the background color of each treemap data cell. This field is
   * optional. If not specified, size_data is used to determine background colors. If specified, the
   * data is expected to be numeric. color_scale will determine how the values in this data map to
   * data cell background colors.
   * @param colorData colorData or {@code null} for none
   */
  public TreemapChartSpec setColorData(ChartData colorData) {
    this.colorData = colorData;
    return this;
  }

  /**
   * The color scale for data cells in the treemap chart. Data cells are assigned colors based on
   * their color values. These color values come from color_data, or from size_data if color_data is
   * not specified. Cells with color values less than or equal to min_value will have minValueColor
   * as their background color. Cells with color values greater than or equal to max_value will have
   * maxValueColor as their background color. Cells with color values between min_value and
   * max_value will have background colors on a gradient between minValueColor and maxValueColor,
   * the midpoint of the gradient being midValueColor. Cells with missing or non-numeric color
   * values will have noDataColor as their background color.
   * @return value or {@code null} for none
   */
  public TreemapChartColorScale getColorScale() {
    return colorScale;
  }

  /**
   * The color scale for data cells in the treemap chart. Data cells are assigned colors based on
   * their color values. These color values come from color_data, or from size_data if color_data is
   * not specified. Cells with color values less than or equal to min_value will have minValueColor
   * as their background color. Cells with color values greater than or equal to max_value will have
   * maxValueColor as their background color. Cells with color values between min_value and
   * max_value will have background colors on a gradient between minValueColor and maxValueColor,
   * the midpoint of the gradient being midValueColor. Cells with missing or non-numeric color
   * values will have noDataColor as their background color.
   * @param colorScale colorScale or {@code null} for none
   */
  public TreemapChartSpec setColorScale(TreemapChartColorScale colorScale) {
    this.colorScale = colorScale;
    return this;
  }

  /**
   * The background color for header cells.
   * @return value or {@code null} for none
   */
  public Color getHeaderColor() {
    return headerColor;
  }

  /**
   * The background color for header cells.
   * @param headerColor headerColor or {@code null} for none
   */
  public TreemapChartSpec setHeaderColor(Color headerColor) {
    this.headerColor = headerColor;
    return this;
  }

  /**
   * True to hide tooltips.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHideTooltips() {
    return hideTooltips;
  }

  /**
   * True to hide tooltips.
   * @param hideTooltips hideTooltips or {@code null} for none
   */
  public TreemapChartSpec setHideTooltips(java.lang.Boolean hideTooltips) {
    this.hideTooltips = hideTooltips;
    return this;
  }

  /**
   * The number of additional data levels beyond the labeled levels to be shown on the treemap
   * chart. These levels are not interactive and are shown without their labels. Defaults to 0 if
   * not specified.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHintedLevels() {
    return hintedLevels;
  }

  /**
   * The number of additional data levels beyond the labeled levels to be shown on the treemap
   * chart. These levels are not interactive and are shown without their labels. Defaults to 0 if
   * not specified.
   * @param hintedLevels hintedLevels or {@code null} for none
   */
  public TreemapChartSpec setHintedLevels(java.lang.Integer hintedLevels) {
    this.hintedLevels = hintedLevels;
    return this;
  }

  /**
   * The data that contains the treemap cell labels.
   * @return value or {@code null} for none
   */
  public ChartData getLabels() {
    return labels;
  }

  /**
   * The data that contains the treemap cell labels.
   * @param labels labels or {@code null} for none
   */
  public TreemapChartSpec setLabels(ChartData labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The number of data levels to show on the treemap chart. These levels are interactive and are
   * shown with their labels. Defaults to 2 if not specified.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLevels() {
    return levels;
  }

  /**
   * The number of data levels to show on the treemap chart. These levels are interactive and are
   * shown with their labels. Defaults to 2 if not specified.
   * @param levels levels or {@code null} for none
   */
  public TreemapChartSpec setLevels(java.lang.Integer levels) {
    this.levels = levels;
    return this;
  }

  /**
   * The maximum possible data value. Cells with values greater than this will have the same color
   * as cells with this value. If not specified, defaults to the actual maximum value from
   * color_data, or the maximum value from size_data if color_data is not specified.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMaxValue() {
    return maxValue;
  }

  /**
   * The maximum possible data value. Cells with values greater than this will have the same color
   * as cells with this value. If not specified, defaults to the actual maximum value from
   * color_data, or the maximum value from size_data if color_data is not specified.
   * @param maxValue maxValue or {@code null} for none
   */
  public TreemapChartSpec setMaxValue(java.lang.Double maxValue) {
    this.maxValue = maxValue;
    return this;
  }

  /**
   * The minimum possible data value. Cells with values less than this will have the same color as
   * cells with this value. If not specified, defaults to the actual minimum value from color_data,
   * or the minimum value from size_data if color_data is not specified.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMinValue() {
    return minValue;
  }

  /**
   * The minimum possible data value. Cells with values less than this will have the same color as
   * cells with this value. If not specified, defaults to the actual minimum value from color_data,
   * or the minimum value from size_data if color_data is not specified.
   * @param minValue minValue or {@code null} for none
   */
  public TreemapChartSpec setMinValue(java.lang.Double minValue) {
    this.minValue = minValue;
    return this;
  }

  /**
   * The data the contains the treemap cells' parent labels.
   * @return value or {@code null} for none
   */
  public ChartData getParentLabels() {
    return parentLabels;
  }

  /**
   * The data the contains the treemap cells' parent labels.
   * @param parentLabels parentLabels or {@code null} for none
   */
  public TreemapChartSpec setParentLabels(ChartData parentLabels) {
    this.parentLabels = parentLabels;
    return this;
  }

  /**
   * The data that determines the size of each treemap data cell. This data is expected to be
   * numeric. The cells corresponding to non-numeric or missing data will not be rendered. If
   * color_data is not specified, this data is used to determine data cell background colors as
   * well.
   * @return value or {@code null} for none
   */
  public ChartData getSizeData() {
    return sizeData;
  }

  /**
   * The data that determines the size of each treemap data cell. This data is expected to be
   * numeric. The cells corresponding to non-numeric or missing data will not be rendered. If
   * color_data is not specified, this data is used to determine data cell background colors as
   * well.
   * @param sizeData sizeData or {@code null} for none
   */
  public TreemapChartSpec setSizeData(ChartData sizeData) {
    this.sizeData = sizeData;
    return this;
  }

  /**
   * The text format for all labels on the chart.
   * @return value or {@code null} for none
   */
  public TextFormat getTextFormat() {
    return textFormat;
  }

  /**
   * The text format for all labels on the chart.
   * @param textFormat textFormat or {@code null} for none
   */
  public TreemapChartSpec setTextFormat(TextFormat textFormat) {
    this.textFormat = textFormat;
    return this;
  }

  @Override
  public TreemapChartSpec set(String fieldName, Object value) {
    return (TreemapChartSpec) super.set(fieldName, value);
  }

  @Override
  public TreemapChartSpec clone() {
    return (TreemapChartSpec) super.clone();
  }

}
