/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-10-15 at 18:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Deletes a range of cells, shifting other cells into the deleted area.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range of cells to delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The dimension from which deleted cells will be replaced with. If ROWS, existing cells will be
   * shifted upward to replace the deleted cells. If COLUMNS, existing cells will be shifted left to
   * replace the deleted cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shiftDimension;

  /**
   * The range of cells to delete.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range of cells to delete.
   * @param range range or {@code null} for none
   */
  public DeleteRangeRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The dimension from which deleted cells will be replaced with. If ROWS, existing cells will be
   * shifted upward to replace the deleted cells. If COLUMNS, existing cells will be shifted left to
   * replace the deleted cells.
   * @return value or {@code null} for none
   */
  public java.lang.String getShiftDimension() {
    return shiftDimension;
  }

  /**
   * The dimension from which deleted cells will be replaced with. If ROWS, existing cells will be
   * shifted upward to replace the deleted cells. If COLUMNS, existing cells will be shifted left to
   * replace the deleted cells.
   * @param shiftDimension shiftDimension or {@code null} for none
   */
  public DeleteRangeRequest setShiftDimension(java.lang.String shiftDimension) {
    this.shiftDimension = shiftDimension;
    return this;
  }

  @Override
  public DeleteRangeRequest set(String fieldName, Object value) {
    return (DeleteRangeRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteRangeRequest clone() {
    return (DeleteRangeRequest) super.clone();
  }

}
