/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-10-15 at 19:50:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A single grouping (either row or column) in a pivot table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotGroup extends com.google.api.client.json.GenericJson {

  /**
   * The group rule to apply to this row/column group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PivotGroupRule groupRule;

  /**
   * The labels to use for the row/column groups which can be customized. For example, in the
   * following pivot table, the row label is `Region` (which could be renamed to `State`) and the
   * column label is `Product` (which could be renamed `Item`). Pivot tables created before December
   * 2017 do not have header labels. If you'd like to add header labels to an existing pivot table,
   * please delete the existing pivot table and then create a new pivot table with same parameters.
   *
   *     +--------------+---------+-------+     | SUM of Units | Product |       |     | Region
   * | Pen     | Paper |     +--------------+---------+-------+     | New York     |     345 |    98
   * |     | Oregon       |     234 |   123 |     | Tennessee    |     531 |   415 |
   * +--------------+---------+-------+     | Grand Total  |    1110 |   636 |
   * +--------------+---------+-------+
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * True if the headings in this pivot group should be repeated. This is only valid for row
   * groupings and is ignored by columns.
   *
   * By default, we minimize repitition of headings by not showing higher level headings where they
   * are the same. For example, even though the third row below corresponds to "Q1 Mar", "Q1" is not
   * shown because it is redundant with previous rows. Setting repeat_headings to true would cause
   * "Q1" to be repeated for "Feb" and "Mar".
   *
   *     +--------------+     | Q1     | Jan |     |        | Feb |     |        | Mar |
   * +--------+-----+     | Q1 Total     |     +--------------+
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean repeatHeadings;

  /**
   * True if the pivot table should include the totals for this grouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showTotals;

  /**
   * The order the values in this group should be sorted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sortOrder;

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sourceColumnOffset;

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PivotGroupSortValueBucket valueBucket;

  /**
   * Metadata about values in the grouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PivotGroupValueMetadata> valueMetadata;

  static {
    // hack to force ProGuard to consider PivotGroupValueMetadata used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PivotGroupValueMetadata.class);
  }

  /**
   * The group rule to apply to this row/column group.
   * @return value or {@code null} for none
   */
  public PivotGroupRule getGroupRule() {
    return groupRule;
  }

  /**
   * The group rule to apply to this row/column group.
   * @param groupRule groupRule or {@code null} for none
   */
  public PivotGroup setGroupRule(PivotGroupRule groupRule) {
    this.groupRule = groupRule;
    return this;
  }

  /**
   * The labels to use for the row/column groups which can be customized. For example, in the
   * following pivot table, the row label is `Region` (which could be renamed to `State`) and the
   * column label is `Product` (which could be renamed `Item`). Pivot tables created before December
   * 2017 do not have header labels. If you'd like to add header labels to an existing pivot table,
   * please delete the existing pivot table and then create a new pivot table with same parameters.
   *
   *     +--------------+---------+-------+     | SUM of Units | Product |       |     | Region
   * | Pen     | Paper |     +--------------+---------+-------+     | New York     |     345 |    98
   * |     | Oregon       |     234 |   123 |     | Tennessee    |     531 |   415 |
   * +--------------+---------+-------+     | Grand Total  |    1110 |   636 |
   * +--------------+---------+-------+
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The labels to use for the row/column groups which can be customized. For example, in the
   * following pivot table, the row label is `Region` (which could be renamed to `State`) and the
   * column label is `Product` (which could be renamed `Item`). Pivot tables created before December
   * 2017 do not have header labels. If you'd like to add header labels to an existing pivot table,
   * please delete the existing pivot table and then create a new pivot table with same parameters.
   *
   *     +--------------+---------+-------+     | SUM of Units | Product |       |     | Region
   * | Pen     | Paper |     +--------------+---------+-------+     | New York     |     345 |    98
   * |     | Oregon       |     234 |   123 |     | Tennessee    |     531 |   415 |
   * +--------------+---------+-------+     | Grand Total  |    1110 |   636 |
   * +--------------+---------+-------+
   * @param label label or {@code null} for none
   */
  public PivotGroup setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * True if the headings in this pivot group should be repeated. This is only valid for row
   * groupings and is ignored by columns.
   *
   * By default, we minimize repitition of headings by not showing higher level headings where they
   * are the same. For example, even though the third row below corresponds to "Q1 Mar", "Q1" is not
   * shown because it is redundant with previous rows. Setting repeat_headings to true would cause
   * "Q1" to be repeated for "Feb" and "Mar".
   *
   *     +--------------+     | Q1     | Jan |     |        | Feb |     |        | Mar |
   * +--------+-----+     | Q1 Total     |     +--------------+
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRepeatHeadings() {
    return repeatHeadings;
  }

  /**
   * True if the headings in this pivot group should be repeated. This is only valid for row
   * groupings and is ignored by columns.
   *
   * By default, we minimize repitition of headings by not showing higher level headings where they
   * are the same. For example, even though the third row below corresponds to "Q1 Mar", "Q1" is not
   * shown because it is redundant with previous rows. Setting repeat_headings to true would cause
   * "Q1" to be repeated for "Feb" and "Mar".
   *
   *     +--------------+     | Q1     | Jan |     |        | Feb |     |        | Mar |
   * +--------+-----+     | Q1 Total     |     +--------------+
   * @param repeatHeadings repeatHeadings or {@code null} for none
   */
  public PivotGroup setRepeatHeadings(java.lang.Boolean repeatHeadings) {
    this.repeatHeadings = repeatHeadings;
    return this;
  }

  /**
   * True if the pivot table should include the totals for this grouping.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowTotals() {
    return showTotals;
  }

  /**
   * True if the pivot table should include the totals for this grouping.
   * @param showTotals showTotals or {@code null} for none
   */
  public PivotGroup setShowTotals(java.lang.Boolean showTotals) {
    this.showTotals = showTotals;
    return this;
  }

  /**
   * The order the values in this group should be sorted.
   * @return value or {@code null} for none
   */
  public java.lang.String getSortOrder() {
    return sortOrder;
  }

  /**
   * The order the values in this group should be sorted.
   * @param sortOrder sortOrder or {@code null} for none
   */
  public PivotGroup setSortOrder(java.lang.String sortOrder) {
    this.sortOrder = sortOrder;
    return this;
  }

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSourceColumnOffset() {
    return sourceColumnOffset;
  }

  /**
   * The column offset of the source range that this grouping is based on.
   *
   * For example, if the source was `C10:E15`, a `sourceColumnOffset` of `0` means this group refers
   * to column `C`, whereas the offset `1` would refer to column `D`.
   * @param sourceColumnOffset sourceColumnOffset or {@code null} for none
   */
  public PivotGroup setSourceColumnOffset(java.lang.Integer sourceColumnOffset) {
    this.sourceColumnOffset = sourceColumnOffset;
    return this;
  }

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * @return value or {@code null} for none
   */
  public PivotGroupSortValueBucket getValueBucket() {
    return valueBucket;
  }

  /**
   * The bucket of the opposite pivot group to sort by. If not specified, sorting is alphabetical by
   * this group's values.
   * @param valueBucket valueBucket or {@code null} for none
   */
  public PivotGroup setValueBucket(PivotGroupSortValueBucket valueBucket) {
    this.valueBucket = valueBucket;
    return this;
  }

  /**
   * Metadata about values in the grouping.
   * @return value or {@code null} for none
   */
  public java.util.List<PivotGroupValueMetadata> getValueMetadata() {
    return valueMetadata;
  }

  /**
   * Metadata about values in the grouping.
   * @param valueMetadata valueMetadata or {@code null} for none
   */
  public PivotGroup setValueMetadata(java.util.List<PivotGroupValueMetadata> valueMetadata) {
    this.valueMetadata = valueMetadata;
    return this;
  }

  @Override
  public PivotGroup set(String fieldName, Object value) {
    return (PivotGroup) super.set(fieldName, value);
  }

  @Override
  public PivotGroup clone() {
    return (PivotGroup) super.clone();
  }

}
