/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-14 at 02:12:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Resource that represents a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Spreadsheet extends com.google.api.client.json.GenericJson {

  /**
   * The developer metadata associated with a spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeveloperMetadata> developerMetadata;

  /**
   * The named ranges defined in a spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NamedRange> namedRanges;

  /**
   * Overall properties of a spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpreadsheetProperties properties;

  /**
   * The sheets that are part of a spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Sheet> sheets;

  /**
   * The ID of the spreadsheet. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spreadsheetId;

  /**
   * The url of the spreadsheet. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spreadsheetUrl;

  /**
   * The developer metadata associated with a spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<DeveloperMetadata> getDeveloperMetadata() {
    return developerMetadata;
  }

  /**
   * The developer metadata associated with a spreadsheet.
   * @param developerMetadata developerMetadata or {@code null} for none
   */
  public Spreadsheet setDeveloperMetadata(java.util.List<DeveloperMetadata> developerMetadata) {
    this.developerMetadata = developerMetadata;
    return this;
  }

  /**
   * The named ranges defined in a spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<NamedRange> getNamedRanges() {
    return namedRanges;
  }

  /**
   * The named ranges defined in a spreadsheet.
   * @param namedRanges namedRanges or {@code null} for none
   */
  public Spreadsheet setNamedRanges(java.util.List<NamedRange> namedRanges) {
    this.namedRanges = namedRanges;
    return this;
  }

  /**
   * Overall properties of a spreadsheet.
   * @return value or {@code null} for none
   */
  public SpreadsheetProperties getProperties() {
    return properties;
  }

  /**
   * Overall properties of a spreadsheet.
   * @param properties properties or {@code null} for none
   */
  public Spreadsheet setProperties(SpreadsheetProperties properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The sheets that are part of a spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<Sheet> getSheets() {
    return sheets;
  }

  /**
   * The sheets that are part of a spreadsheet.
   * @param sheets sheets or {@code null} for none
   */
  public Spreadsheet setSheets(java.util.List<Sheet> sheets) {
    this.sheets = sheets;
    return this;
  }

  /**
   * The ID of the spreadsheet. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpreadsheetId() {
    return spreadsheetId;
  }

  /**
   * The ID of the spreadsheet. This field is read-only.
   * @param spreadsheetId spreadsheetId or {@code null} for none
   */
  public Spreadsheet setSpreadsheetId(java.lang.String spreadsheetId) {
    this.spreadsheetId = spreadsheetId;
    return this;
  }

  /**
   * The url of the spreadsheet. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpreadsheetUrl() {
    return spreadsheetUrl;
  }

  /**
   * The url of the spreadsheet. This field is read-only.
   * @param spreadsheetUrl spreadsheetUrl or {@code null} for none
   */
  public Spreadsheet setSpreadsheetUrl(java.lang.String spreadsheetUrl) {
    this.spreadsheetUrl = spreadsheetUrl;
    return this;
  }

  @Override
  public Spreadsheet set(String fieldName, Object value) {
    return (Spreadsheet) super.set(fieldName, value);
  }

  @Override
  public Spreadsheet clone() {
    return (Spreadsheet) super.clone();
  }

}
