/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-14 at 02:12:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates a conditional format rule at the given index, or moves a conditional format rule to
 * another index.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateConditionalFormatRuleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The zero-based index of the rule that should be replaced or moved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * The zero-based new index the rule should end up at.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer newIndex;

  /**
   * The rule that should replace the rule at the given index.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConditionalFormatRule rule;

  /**
   * The sheet of the rule to move.  Required if new_index is set, unused otherwise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * The zero-based index of the rule that should be replaced or moved.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * The zero-based index of the rule that should be replaced or moved.
   * @param index index or {@code null} for none
   */
  public UpdateConditionalFormatRuleRequest setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * The zero-based new index the rule should end up at.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNewIndex() {
    return newIndex;
  }

  /**
   * The zero-based new index the rule should end up at.
   * @param newIndex newIndex or {@code null} for none
   */
  public UpdateConditionalFormatRuleRequest setNewIndex(java.lang.Integer newIndex) {
    this.newIndex = newIndex;
    return this;
  }

  /**
   * The rule that should replace the rule at the given index.
   * @return value or {@code null} for none
   */
  public ConditionalFormatRule getRule() {
    return rule;
  }

  /**
   * The rule that should replace the rule at the given index.
   * @param rule rule or {@code null} for none
   */
  public UpdateConditionalFormatRuleRequest setRule(ConditionalFormatRule rule) {
    this.rule = rule;
    return this;
  }

  /**
   * The sheet of the rule to move.  Required if new_index is set, unused otherwise.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet of the rule to move.  Required if new_index is set, unused otherwise.
   * @param sheetId sheetId or {@code null} for none
   */
  public UpdateConditionalFormatRuleRequest setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  @Override
  public UpdateConditionalFormatRuleRequest set(String fieldName, Object value) {
    return (UpdateConditionalFormatRuleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateConditionalFormatRuleRequest clone() {
    return (UpdateConditionalFormatRuleRequest) super.clone();
  }

}
