/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-27 at 03:17:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * An org chart. Org charts require a unique set of labels in labels and may optionally include
 * parent_labels and tooltips. parent_labels contain, for each node, the label identifying the
 * parent node.  tooltips contain, for each node, an optional tooltip.
 *
 * For example, to describe an OrgChart with Alice as the CEO, Bob as the President (reporting to
 * Alice) and Cathy as VP of Sales (also reporting to Alice), have labels contain "Alice", "Bob",
 * "Cathy", parent_labels contain "", "Alice", "Alice" and tooltips contain "CEO", "President", "VP
 * Sales".
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrgChartSpec extends com.google.api.client.json.GenericJson {

  /**
   * The data containing the labels for all the nodes in the chart.  Labels must be unique.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData labels;

  /**
   * The color of the org chart nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color nodeColor;

  /**
   * The size of the org chart nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nodeSize;

  /**
   * The data containing the label of the parent for the corresponding node. A blank value indicates
   * that the node has no parent and is a top-level node. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData parentLabels;

  /**
   * The color of the selected org chart nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color selectedNodeColor;

  /**
   * The data containing the tooltip for the corresponding node.  A blank value results in no
   * tooltip being displayed for the node. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData tooltips;

  /**
   * The data containing the labels for all the nodes in the chart.  Labels must be unique.
   * @return value or {@code null} for none
   */
  public ChartData getLabels() {
    return labels;
  }

  /**
   * The data containing the labels for all the nodes in the chart.  Labels must be unique.
   * @param labels labels or {@code null} for none
   */
  public OrgChartSpec setLabels(ChartData labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The color of the org chart nodes.
   * @return value or {@code null} for none
   */
  public Color getNodeColor() {
    return nodeColor;
  }

  /**
   * The color of the org chart nodes.
   * @param nodeColor nodeColor or {@code null} for none
   */
  public OrgChartSpec setNodeColor(Color nodeColor) {
    this.nodeColor = nodeColor;
    return this;
  }

  /**
   * The size of the org chart nodes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNodeSize() {
    return nodeSize;
  }

  /**
   * The size of the org chart nodes.
   * @param nodeSize nodeSize or {@code null} for none
   */
  public OrgChartSpec setNodeSize(java.lang.String nodeSize) {
    this.nodeSize = nodeSize;
    return this;
  }

  /**
   * The data containing the label of the parent for the corresponding node. A blank value indicates
   * that the node has no parent and is a top-level node. This field is optional.
   * @return value or {@code null} for none
   */
  public ChartData getParentLabels() {
    return parentLabels;
  }

  /**
   * The data containing the label of the parent for the corresponding node. A blank value indicates
   * that the node has no parent and is a top-level node. This field is optional.
   * @param parentLabels parentLabels or {@code null} for none
   */
  public OrgChartSpec setParentLabels(ChartData parentLabels) {
    this.parentLabels = parentLabels;
    return this;
  }

  /**
   * The color of the selected org chart nodes.
   * @return value or {@code null} for none
   */
  public Color getSelectedNodeColor() {
    return selectedNodeColor;
  }

  /**
   * The color of the selected org chart nodes.
   * @param selectedNodeColor selectedNodeColor or {@code null} for none
   */
  public OrgChartSpec setSelectedNodeColor(Color selectedNodeColor) {
    this.selectedNodeColor = selectedNodeColor;
    return this;
  }

  /**
   * The data containing the tooltip for the corresponding node.  A blank value results in no
   * tooltip being displayed for the node. This field is optional.
   * @return value or {@code null} for none
   */
  public ChartData getTooltips() {
    return tooltips;
  }

  /**
   * The data containing the tooltip for the corresponding node.  A blank value results in no
   * tooltip being displayed for the node. This field is optional.
   * @param tooltips tooltips or {@code null} for none
   */
  public OrgChartSpec setTooltips(ChartData tooltips) {
    this.tooltips = tooltips;
    return this;
  }

  @Override
  public OrgChartSpec set(String fieldName, Object value) {
    return (OrgChartSpec) super.set(fieldName, value);
  }

  @Override
  public OrgChartSpec clone() {
    return (OrgChartSpec) super.clone();
  }

}
