/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-27 at 03:17:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The editors of a protected range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Editors extends com.google.api.client.json.GenericJson {

  /**
   * True if anyone in the document's domain has edit access to the protected range.  Domain
   * protection is only supported on documents within a domain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean domainUsersCanEdit;

  /**
   * The email addresses of groups with edit access to the protected range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> groups;

  /**
   * The email addresses of users with edit access to the protected range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> users;

  /**
   * True if anyone in the document's domain has edit access to the protected range.  Domain
   * protection is only supported on documents within a domain.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDomainUsersCanEdit() {
    return domainUsersCanEdit;
  }

  /**
   * True if anyone in the document's domain has edit access to the protected range.  Domain
   * protection is only supported on documents within a domain.
   * @param domainUsersCanEdit domainUsersCanEdit or {@code null} for none
   */
  public Editors setDomainUsersCanEdit(java.lang.Boolean domainUsersCanEdit) {
    this.domainUsersCanEdit = domainUsersCanEdit;
    return this;
  }

  /**
   * The email addresses of groups with edit access to the protected range.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getGroups() {
    return groups;
  }

  /**
   * The email addresses of groups with edit access to the protected range.
   * @param groups groups or {@code null} for none
   */
  public Editors setGroups(java.util.List<java.lang.String> groups) {
    this.groups = groups;
    return this;
  }

  /**
   * The email addresses of users with edit access to the protected range.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUsers() {
    return users;
  }

  /**
   * The email addresses of users with edit access to the protected range.
   * @param users users or {@code null} for none
   */
  public Editors setUsers(java.util.List<java.lang.String> users) {
    this.users = users;
    return this;
  }

  @Override
  public Editors set(String fieldName, Object value) {
    return (Editors) super.set(fieldName, value);
  }

  @Override
  public Editors clone() {
    return (Editors) super.clone();
  }

}
