/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-04 at 23:20:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Adds a named range to the spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddNamedRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The named range to add. The namedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NamedRange namedRange;

  /**
   * The named range to add. The namedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * @return value or {@code null} for none
   */
  public NamedRange getNamedRange() {
    return namedRange;
  }

  /**
   * The named range to add. The namedRangeId field is optional; if one is not set, an id will be
   * randomly generated. (It is an error to specify the ID of a range that already exists.)
   * @param namedRange namedRange or {@code null} for none
   */
  public AddNamedRangeRequest setNamedRange(NamedRange namedRange) {
    this.namedRange = namedRange;
    return this;
  }

  @Override
  public AddNamedRangeRequest set(String fieldName, Object value) {
    return (AddNamedRangeRequest) super.set(fieldName, value);
  }

  @Override
  public AddNamedRangeRequest clone() {
    return (AddNamedRangeRequest) super.clone();
  }

}
