/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-09 at 00:03:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Allows you to organize the date-time values in a source data column into buckets based on
 * selected parts of their date or time values. For example, consider a pivot table showing sales
 * transactions by date:
 *
 *     +----------+--------------+     | Date     | SUM of Sales |     +----------+--------------+
 * | 1/1/2017 |      $621.14 |     | 2/3/2017 |      $708.84 |     | 5/8/2017 |      $326.84 |
 * ...     +----------+--------------+ Applying a date-time group rule with a DateTimeRuleType of
 * YEAR_MONTH results in the following pivot table.
 *
 *     +--------------+--------------+     | Grouped Date | SUM of Sales |
 * +--------------+--------------+     | 2017-Jan     |   $53,731.78 |     | 2017-Feb     |
 * $83,475.32 |     | 2017-Mar     |   $94,385.05 |     ...     +--------------+--------------+
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DateTimeRule extends com.google.api.client.json.GenericJson {

  /**
   * The type of date-time grouping to apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The type of date-time grouping to apply.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of date-time grouping to apply.
   * @param type type or {@code null} for none
   */
  public DateTimeRule setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public DateTimeRule set(String fieldName, Object value) {
    return (DateTimeRule) super.set(fieldName, value);
  }

  @Override
  public DateTimeRule clone() {
    return (DateTimeRule) super.clone();
  }

}
