/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-09 at 00:03:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A filter view.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterView extends com.google.api.client.json.GenericJson {

  /**
   * The criteria for showing/hiding values per column. The map's key is the column index, and the
   * value is the criteria for that column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FilterCriteria> criteria;

  static {
    // hack to force ProGuard to consider FilterCriteria used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FilterCriteria.class);
  }

  /**
   * The ID of the filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer filterViewId;

  /**
   * The named range this filter view is backed by, if any.
   *
   * When writing, only one of range or named_range_id may be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namedRangeId;

  /**
   * The range this filter view covers.
   *
   * When writing, only one of range or named_range_id may be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SortSpec> sortSpecs;

  static {
    // hack to force ProGuard to consider SortSpec used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SortSpec.class);
  }

  /**
   * The name of the filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The criteria for showing/hiding values per column. The map's key is the column index, and the
   * value is the criteria for that column.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FilterCriteria> getCriteria() {
    return criteria;
  }

  /**
   * The criteria for showing/hiding values per column. The map's key is the column index, and the
   * value is the criteria for that column.
   * @param criteria criteria or {@code null} for none
   */
  public FilterView setCriteria(java.util.Map<String, FilterCriteria> criteria) {
    this.criteria = criteria;
    return this;
  }

  /**
   * The ID of the filter view.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFilterViewId() {
    return filterViewId;
  }

  /**
   * The ID of the filter view.
   * @param filterViewId filterViewId or {@code null} for none
   */
  public FilterView setFilterViewId(java.lang.Integer filterViewId) {
    this.filterViewId = filterViewId;
    return this;
  }

  /**
   * The named range this filter view is backed by, if any.
   *
   * When writing, only one of range or named_range_id may be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamedRangeId() {
    return namedRangeId;
  }

  /**
   * The named range this filter view is backed by, if any.
   *
   * When writing, only one of range or named_range_id may be set.
   * @param namedRangeId namedRangeId or {@code null} for none
   */
  public FilterView setNamedRangeId(java.lang.String namedRangeId) {
    this.namedRangeId = namedRangeId;
    return this;
  }

  /**
   * The range this filter view covers.
   *
   * When writing, only one of range or named_range_id may be set.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range this filter view covers.
   *
   * When writing, only one of range or named_range_id may be set.
   * @param range range or {@code null} for none
   */
  public FilterView setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * @return value or {@code null} for none
   */
  public java.util.List<SortSpec> getSortSpecs() {
    return sortSpecs;
  }

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * @param sortSpecs sortSpecs or {@code null} for none
   */
  public FilterView setSortSpecs(java.util.List<SortSpec> sortSpecs) {
    this.sortSpecs = sortSpecs;
    return this;
  }

  /**
   * The name of the filter view.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The name of the filter view.
   * @param title title or {@code null} for none
   */
  public FilterView setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public FilterView set(String fieldName, Object value) {
    return (FilterView) super.set(fieldName, value);
  }

  @Override
  public FilterView clone() {
    return (FilterView) super.clone();
  }

}
